/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.JavaVersionAwareVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3824")
public class MapComputeIfAbsentOrPresentCheck
extends SECheck
implements JavaVersionAwareVisitor {
    private static final MethodMatchers.NameBuilder JAVA_UTIL_MAP = MethodMatchers.create().ofSubTypes(new String[]{"java.util.Map"});
    private static final MethodMatchers MAP_GET = JAVA_UTIL_MAP.names(new String[]{"get"}).addParametersMatcher(new String[]{"*"}).build();
    private static final MethodMatchers MAP_PUT = JAVA_UTIL_MAP.names(new String[]{"put"}).addParametersMatcher(new String[]{"*", "*"}).build();
    private static final MethodMatchers MAP_CONTAINS_KEY = JAVA_UTIL_MAP.names(new String[]{"containsKey"}).addParametersMatcher(new String[]{"*"}).build();
    private final Map<SymbolicValue, List<MapMethodInvocation>> mapGetInvocations = new HashMap<SymbolicValue, List<MapMethodInvocation>>();
    private final Map<SymbolicValue, List<MapMethodInvocation>> mapContainsKeyInvocations = new HashMap<SymbolicValue, List<MapMethodInvocation>>();
    private final List<CheckIssue> checkIssues = new ArrayList<CheckIssue>();
    private final Map<Tree, IfStatementTree> closestIfStatements = new HashMap<Tree, IfStatementTree>();

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.mapContainsKeyInvocations.clear();
        this.mapGetInvocations.clear();
        this.checkIssues.clear();
        this.closestIfStatements.clear();
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)syntaxNode;
            if (MAP_GET.matches(mit)) {
                MapComputeIfAbsentOrPresentCheck.addMapMethodInvocation(context, mit, this.mapGetInvocations);
            } else if (MAP_CONTAINS_KEY.matches(mit)) {
                MapComputeIfAbsentOrPresentCheck.addMapMethodInvocation(context, mit, this.mapContainsKeyInvocations);
            }
        }
        return super.checkPostStatement(context, syntaxNode);
    }

    private static void addMapMethodInvocation(CheckerContext context, MethodInvocationTree mit, Map<SymbolicValue, List<MapMethodInvocation>> invocations) {
        ProgramState psBeforeInvocation = context.getNode().programState;
        ProgramState psAfterInvocation = context.getState();
        SymbolicValue keySV = psBeforeInvocation.peekValue(0);
        SymbolicValue mapSV = psBeforeInvocation.peekValue(1);
        SymbolicValue valueSV = psAfterInvocation.peekValue();
        Objects.requireNonNull(valueSV);
        invocations.computeIfAbsent(mapSV, k -> new ArrayList()).add(new MapMethodInvocation(valueSV, keySV, mit));
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        ExpressionTree valueArgument;
        MethodInvocationTree mit;
        if (syntaxNode.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && MAP_PUT.matches(mit = (MethodInvocationTree)syntaxNode) && !MapComputeIfAbsentOrPresentCheck.isMethodInvocationThrowingCheckedException(valueArgument = (ExpressionTree)mit.arguments().get(1)) && !valueArgument.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            this.checkForGetAndContainsKeyInvocations(context, mit);
        }
        return super.checkPreStatement(context, syntaxNode);
    }

    private void checkForGetAndContainsKeyInvocations(CheckerContext context, MethodInvocationTree mit) {
        ProgramState ps = context.getState();
        SymbolicValue keySV = ps.peekValue(1);
        SymbolicValue mapSV = ps.peekValue(2);
        MapComputeIfAbsentOrPresentCheck.sameMapAndSameKeyInvocation(keySV, mapSV, this.mapGetInvocations).ifPresent(getOnSameMap -> {
            ObjectConstraint constraint = ps.getConstraint(getOnSameMap.value, ObjectConstraint.class);
            if (constraint != null && this.isInsideIfStatementWithNullCheckWithoutElse(mit)) {
                this.checkIssues.add(new GetMethodCheckIssue(context.getNode(), getOnSameMap.mit, mit, getOnSameMap.value, constraint));
            }
        });
        MapComputeIfAbsentOrPresentCheck.sameMapAndSameKeyInvocation(keySV, mapSV, this.mapContainsKeyInvocations).ifPresent(containsKeyOnSameMap -> {
            BooleanConstraint constraint = ps.getConstraint(containsKeyOnSameMap.value, BooleanConstraint.class);
            if (constraint != null && this.isInsideIfStatementWithoutElse(mit)) {
                this.checkIssues.add(new ContainsKeyMethodCheckIssue(context.getNode(), containsKeyOnSameMap.mit, mit, containsKeyOnSameMap.value, constraint));
            }
        });
    }

    private static Optional<MapMethodInvocation> sameMapAndSameKeyInvocation(SymbolicValue keySV, SymbolicValue mapSV, Map<SymbolicValue, List<MapMethodInvocation>> mapGetInvocations) {
        return mapGetInvocations.getOrDefault(mapSV, Collections.emptyList()).stream().filter(getOnSameMap -> getOnSameMap.withSameKey(keySV)).findAny();
    }

    private static boolean isMethodInvocationThrowingCheckedException(ExpressionTree expr) {
        if (!expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        Symbol.MethodSymbol symbol = ((MethodInvocationTree)expr).methodSymbol();
        if (symbol.isUnknown()) {
            return true;
        }
        return symbol.thrownTypes().stream().anyMatch(t -> !t.isSubtypeOf("java.lang.RuntimeException"));
    }

    private boolean isInsideIfStatementWithNullCheckWithoutElse(MethodInvocationTree mit) {
        return this.getIfStatementParent(mit).map(ifStatementTree -> ifStatementTree.elseStatement() == null && MapComputeIfAbsentOrPresentCheck.isNullCheck(ExpressionUtils.skipParentheses((ExpressionTree)ifStatementTree.condition()))).orElse(false);
    }

    private boolean isInsideIfStatementWithoutElse(MethodInvocationTree mit) {
        return this.getIfStatementParent(mit).map(ifStatementTree -> ifStatementTree.elseStatement() == null).orElse(false);
    }

    private Optional<IfStatementTree> getIfStatementParent(MethodInvocationTree mit) {
        IfStatementTree closestKnownParent = this.closestIfStatements.get(mit);
        if (closestKnownParent == null) {
            ArrayList<Tree> children = new ArrayList<Tree>();
            children.add((Tree)mit);
            return this.doGetIfStatementParent(mit.parent(), children);
        }
        return Optional.of(closestKnownParent);
    }

    private Optional<IfStatementTree> doGetIfStatementParent(@Nullable Tree currentTree, List<Tree> children) {
        while (currentTree != null) {
            IfStatementTree ifStatementTree;
            if (currentTree.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
                ifStatementTree = (IfStatementTree)currentTree;
                children.forEach(tree -> this.closestIfStatements.put((Tree)tree, ifStatementTree));
                return Optional.of(ifStatementTree);
            }
            ifStatementTree = this.closestIfStatements.get(currentTree);
            if (ifStatementTree != null) {
                children.forEach(tree -> this.closestIfStatements.put((Tree)tree, ifStatementTree));
                return Optional.of(ifStatementTree);
            }
            children.add(currentTree);
            currentTree = currentTree.parent();
        }
        return Optional.empty();
    }

    private static boolean isNullCheck(ExpressionTree condition) {
        if (condition.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            BinaryExpressionTree bet = (BinaryExpressionTree)condition;
            ExpressionTree rightOperand = ExpressionUtils.skipParentheses((ExpressionTree)bet.rightOperand());
            ExpressionTree leftOperand = ExpressionUtils.skipParentheses((ExpressionTree)bet.leftOperand());
            return rightOperand.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || leftOperand.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }
        return false;
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        MapComputeIfAbsentOrPresentCheck check = this;
        this.checkIssues.stream().filter(checkIssue -> checkIssue.isOnlyPossibleIssueForReportTree(this.checkIssues)).forEach(issue -> issue.report(context, check));
    }

    private static class MapMethodInvocation {
        private final SymbolicValue value;
        private final SymbolicValue key;
        private final MethodInvocationTree mit;

        private MapMethodInvocation(SymbolicValue value, SymbolicValue key, MethodInvocationTree mit) {
            this.value = value;
            this.key = key;
            this.mit = mit;
        }

        private boolean withSameKey(SymbolicValue key) {
            return this.key.equals(key);
        }
    }

    private static abstract class CheckIssue {
        protected final ExplodedGraph.Node node;
        private final MethodInvocationTree checkValueInvocation;
        private final MethodInvocationTree putInvocation;
        protected final SymbolicValue value;
        protected final Constraint valueConstraint;

        private CheckIssue(ExplodedGraph.Node node, MethodInvocationTree checkValueInvocation, MethodInvocationTree putInvocation, SymbolicValue value, Constraint constraint) {
            this.node = node;
            this.checkValueInvocation = checkValueInvocation;
            this.putInvocation = putInvocation;
            this.value = value;
            this.valueConstraint = constraint;
        }

        private boolean isOnlyPossibleIssueForReportTree(List<CheckIssue> otherIssues) {
            return otherIssues.stream().noneMatch(this::differentIssueOnSameTree);
        }

        private boolean differentIssueOnSameTree(CheckIssue otherIssue) {
            return this != otherIssue && this.checkValueInvocation.equals((Object)otherIssue.checkValueInvocation) && this.valueConstraint != otherIssue.valueConstraint;
        }

        protected abstract String issueMsg();

        protected abstract Set<Flow> flows();

        private void report(CheckerContext context, SECheck check) {
            context.reportIssue((Tree)this.checkValueInvocation, check, this.issueMsg(), this.flows());
        }

        protected Set<Flow> flows(String methodName, Set<Flow> flows) {
            return flows.stream().map(flow -> Flow.builder().add(new JavaFileScannerContext.Location("'Map.put()' is invoked with same key.", (Tree)this.putInvocation.methodSelect())).addAll((Flow)flow).add(new JavaFileScannerContext.Location(String.format("'%s' is invoked.", methodName), (Tree)this.checkValueInvocation.methodSelect())).build()).collect(Collectors.toSet());
        }
    }

    private static final class ContainsKeyMethodCheckIssue
    extends CheckIssue {
        private ContainsKeyMethodCheckIssue(ExplodedGraph.Node node, MethodInvocationTree checkValueInvocation, MethodInvocationTree putInvocation, SymbolicValue value, BooleanConstraint constraint) {
            super(node, checkValueInvocation, putInvocation, value, constraint);
        }

        @Override
        protected String issueMsg() {
            return String.format("Replace this \"Map.containsKey()\" with a call to \"Map.%s()\".", this.valueConstraint == BooleanConstraint.FALSE ? "computeIfAbsent" : "computeIfPresent");
        }

        @Override
        protected Set<Flow> flows() {
            Set<Flow> flows = FlowComputation.flow(this.node, this.value, Collections.singletonList(BooleanConstraint.class), 20);
            return this.flows("Map.containsKey()", flows);
        }
    }

    private static final class GetMethodCheckIssue
    extends CheckIssue {
        private GetMethodCheckIssue(ExplodedGraph.Node node, MethodInvocationTree checkValueInvocation, MethodInvocationTree putInvocation, SymbolicValue value, ObjectConstraint valueConstraint) {
            super(node, checkValueInvocation, putInvocation, value, valueConstraint);
        }

        @Override
        protected String issueMsg() {
            return String.format("Replace this \"Map.get()\" and condition with a call to \"Map.%s()\".", this.valueConstraint == ObjectConstraint.NULL ? "computeIfAbsent" : "computeIfPresent");
        }

        @Override
        protected Set<Flow> flows() {
            Set<Flow> flows = FlowComputation.flow(this.node, this.value, Collections.singletonList(ObjectConstraint.class), 20);
            return this.flows("Map.get()", flows);
        }
    }
}

