/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.se.checks.AbstractXMLProcessing;
import org.sonar.java.se.checks.XxeProcessingCheck;
import org.sonar.java.se.checks.XxeProperty;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.plugins.java.api.semantic.MethodMatchers;

@Rule(key="S6376")
public class DenialOfServiceXMLCheck
extends AbstractXMLProcessing {
    private static final List<Class<? extends Constraint>> DOMAINS = Collections.singletonList(XxeProperty.FeatureSecureProcessing.class);
    private static final MethodMatchers PARSING_METHODS_DOS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{XxeProcessingCheck.PARSING_METHODS, XxeProcessingCheck.NEW_DOCUMENT_BUILDER});

    @Override
    protected MethodMatchers getParsingMethods() {
        return PARSING_METHODS_DOS;
    }

    @Override
    protected boolean isUnSecuredByProperty(@Nullable ConstraintsByDomain constraintsByDomain) {
        if (constraintsByDomain == null) {
            return false;
        }
        return constraintsByDomain.hasConstraint(XxeProperty.FeatureSecureProcessing.UNSECURED) && !constraintsByDomain.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED);
    }

    @Override
    protected String getMessage() {
        return "Enable XML parsing limitations to prevent Denial of Service attacks.";
    }

    @Override
    protected boolean shouldTrackConstraint(Constraint constraint) {
        return constraint == XxeProperty.FeatureSecureProcessing.UNSECURED;
    }

    @Override
    protected List<Class<? extends Constraint>> getDomains() {
        return DOMAINS;
    }
}

