/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import org.sonar.java.AnalysisException;
import org.sonar.plugins.jacoco.ExecutionDataVisitor;
import org.sonar.plugins.jacoco.JacocoReportReader;

public final class JaCoCoReportMerger {
    private JaCoCoReportMerger() {
    }

    public static void mergeReports(File reportOverall, File ... reports) {
        ExecutionDataVisitor edv = new ExecutionDataVisitor();
        JaCoCoReportMerger.loadSourceFiles(edv, reports);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(reportOverall));){
            ExecutionDataWriter visitor = new ExecutionDataWriter((OutputStream)outputStream);
            for (Map.Entry<String, ExecutionDataStore> entry : edv.getSessions().entrySet()) {
                SessionInfo sessionInfo = new SessionInfo(entry.getKey(), 0L, 0L);
                ((ISessionInfoVisitor)visitor).visitSessionInfo(sessionInfo);
                entry.getValue().accept((IExecutionDataVisitor)visitor);
            }
        }
        catch (IOException e) {
            throw new AnalysisException(String.format("Unable to write overall coverage report %s", reportOverall.getAbsolutePath()), (Throwable)e);
        }
    }

    private static void loadSourceFiles(ExecutionDataVisitor executionDataVisitor, File ... reports) {
        Arrays.stream(reports).filter(File::isFile).forEach(report -> new JacocoReportReader((File)report).readJacocoReport(executionDataVisitor, executionDataVisitor));
    }
}

