/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.location;

import java.util.List;
import org.sonar.java.model.LineUtils;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.location.Range;

public class InternalRange
implements Range {
    private final Position start;
    private final Position end;

    public InternalRange(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    public InternalRange(Position start, String text) {
        List<String> lines = LineUtils.splitLines(text);
        String lastLine = lines.get(lines.size() - 1);
        int endLine = start.line() + lines.size() - 1;
        int endColumn = (lines.size() == 1 ? start.column() : 1) + lastLine.length();
        this.start = start;
        this.end = Position.at(endLine, endColumn);
    }

    @Override
    public Position start() {
        return this.start;
    }

    @Override
    public Position end() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalRange that = (InternalRange)o;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    public String toString() {
        return "(" + String.valueOf(this.start) + ")-(" + String.valueOf(this.end) + ")";
    }
}

