/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.caching;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.java.caching.CacheReadException;
import org.sonar.plugins.java.api.caching.JavaReadCache;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class JavaReadCacheImpl
implements JavaReadCache {
    private static final Logger LOG = LoggerFactory.getLogger(JavaReadCacheImpl.class);
    private final ReadCache readCache;

    public JavaReadCacheImpl(ReadCache readCache) {
        this.readCache = readCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream read(String key) {
        InputStream read;
        PerformanceMeasure.Duration duration = PerformanceMeasure.start((String)"JavaReadCache.read");
        try {
            read = this.readCache.read(key);
        }
        finally {
            duration.stop();
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public byte[] readBytes(String key) {
        PerformanceMeasure.Duration duration = PerformanceMeasure.start((String)"JavaReadCache.readBytes");
        try {
            if (this.readCache.contains(key)) {
                byte[] byArray;
                block13: {
                    InputStream in = this.read(key);
                    try {
                        byArray = in.readAllBytes();
                        if (in == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new CacheReadException(String.format("Unable to read data for key '%s'", key), e);
                        }
                    }
                    in.close();
                }
                return byArray;
            }
            LOG.trace("Cache miss for key '{}'", (Object)key);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            duration.stop();
        }
    }

    @Override
    public boolean contains(String key) {
        return this.readCache.contains(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaReadCacheImpl that = (JavaReadCacheImpl)o;
        return Objects.equals(this.readCache, that.readCache);
    }

    public int hashCode() {
        return Objects.hash(this.readCache);
    }
}

