/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.ArrayList;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class ComplexityVisitor
extends BaseTreeVisitor {
    private List<Tree> blame = new ArrayList<Tree>();
    private Tree root;
    private static final String DEFAULT_KEYWORD = JavaKeyword.DEFAULT.getValue();

    public List<Tree> getNodes(Tree tree) {
        this.blame.clear();
        this.root = tree;
        this.scan(tree);
        this.root = null;
        return this.blame;
    }

    @Override
    public void visitMethod(MethodTree tree) {
        if (tree.block() != null) {
            this.blame.add(tree.simpleName().identifierToken());
        }
        super.visitMethod(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        if (this.root.is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.COMPILATION_UNIT)) {
            super.visitClass(tree);
        }
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        if (this.root.is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.COMPILATION_UNIT) || lambdaExpressionTree.equals(this.root)) {
            this.blame.add(lambdaExpressionTree.arrowToken());
            super.visitLambdaExpression(lambdaExpressionTree);
        }
    }

    @Override
    public void visitCaseLabel(CaseLabelTree tree) {
        if (!DEFAULT_KEYWORD.equals(tree.caseOrDefaultKeyword().text())) {
            this.blame.add(tree.firstToken());
        }
        super.visitCaseLabel(tree);
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.blame.add(tree.firstToken());
        super.visitForEachStatement(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.blame.add(tree.firstToken());
        super.visitForStatement(tree);
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.blame.add(tree.firstToken());
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.blame.add(tree.firstToken());
        super.visitDoWhileStatement(tree);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.blame.add(tree.firstToken());
        super.visitIfStatement(tree);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.blame.add(tree.questionToken());
        super.visitConditionalExpression(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR)) {
            this.blame.add(tree.operatorToken());
        }
        super.visitBinaryExpression(tree);
    }
}

