/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.ExceptionalYield;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.semantic.Type;

public class ExceptionalCheckBasedYield
extends ExceptionalYield {
    private final Class<? extends SECheck> check;
    private final SymbolicValue svCausingException;
    private final boolean isMethodVarargs;

    public ExceptionalCheckBasedYield(SymbolicValue svCausingException, String exceptionType, Class<? extends SECheck> check, ExplodedGraph.Node node, MethodBehavior behavior) {
        super(node, behavior);
        this.check = check;
        this.svCausingException = svCausingException;
        this.isMethodVarargs = behavior.isMethodVarArgs();
        Preconditions.checkArgument((exceptionType != null ? 1 : 0) != 0, (Object)"Exception type is required");
        super.setExceptionType(exceptionType);
    }

    @Override
    public Stream<ProgramState> statesAfterInvocation(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState, Supplier<SymbolicValue> svSupplier) {
        if (this.parameterConstraintsMatchExactly(invocationArguments, invocationTypes, programState)) {
            return super.statesAfterInvocation(invocationArguments, invocationTypes, programState, svSupplier);
        }
        return Stream.empty();
    }

    private boolean parameterConstraintsMatchExactly(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState) {
        if (!this.applicableOnVarArgs(invocationTypes)) {
            return false;
        }
        for (int index = 0; index < this.parametersConstraints.size(); ++index) {
            ConstraintsByDomain yieldConstraint = (ConstraintsByDomain)this.parametersConstraints.get(index);
            ConstraintsByDomain stateConstraint = ExceptionalCheckBasedYield.argumentConstraint(invocationArguments, programState, index);
            if (yieldConstraint.isEmpty() || yieldConstraint.equals(stateConstraint)) continue;
            return false;
        }
        return true;
    }

    private boolean applicableOnVarArgs(List<Type> invocationTypes) {
        int numberArgumentsInCall;
        int numberParametersYield = this.parametersConstraints.size();
        if (numberParametersYield > (numberArgumentsInCall = invocationTypes.size())) {
            return true;
        }
        ConstraintsByDomain lastParamConstraint = (ConstraintsByDomain)this.parametersConstraints.get(numberParametersYield - 1);
        if (lastParamConstraint.isEmpty()) {
            return true;
        }
        if (numberParametersYield != numberArgumentsInCall) {
            return false;
        }
        Type lastArgumentType = invocationTypes.get(numberArgumentsInCall - 1);
        return !this.isMethodVarargs || lastArgumentType.isArray() || lastArgumentType.is("<nulltype>");
    }

    @CheckForNull
    private static ConstraintsByDomain argumentConstraint(List<SymbolicValue> invocationArguments, ProgramState programState, int index) {
        if (index < invocationArguments.size()) {
            return programState.getConstraints(invocationArguments.get(index));
        }
        return null;
    }

    @Override
    public void setExceptionType(String exceptionType) {
        throw new UnsupportedOperationException("Exception type can not be changed");
    }

    @Override
    @Nonnull
    public Type exceptionType(SemanticModel semanticModel) {
        Type exceptionType = super.exceptionType(semanticModel);
        Preconditions.checkArgument((!exceptionType.isUnknown() ? 1 : 0) != 0, (Object)"Exception type is required");
        return exceptionType;
    }

    public Class<? extends SECheck> check() {
        return this.check;
    }

    @Override
    public String toString() {
        return super.toString().replace('}', ',') + " check: " + this.check.getSimpleName() + "}";
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(11, 1297).appendSuper(super.hashCode()).append(this.check).hashCode();
    }

    @Override
    public Set<Flow> flow(List<Integer> parameterIndices, List<Class<? extends Constraint>> domains) {
        return ImmutableSet.of();
    }

    public Set<Flow> exceptionFlows() {
        List<Class<? extends Constraint>> domains = this.node.programState.getConstraints(this.svCausingException).domains().collect(Collectors.toList());
        return FlowComputation.flow(this.node, this.svCausingException, domains);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionalCheckBasedYield other = (ExceptionalCheckBasedYield)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.svCausingException, (Object)other.svCausingException).append(this.check, other.check).isEquals();
    }

    @Override
    public boolean generatedByCheck(SECheck check) {
        return this.check == check.getClass();
    }

    public int parameterCausingExceptionIndex() {
        return this.methodBehavior().parameters().indexOf(this.svCausingException);
    }
}

