/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks.debug;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.DebugCheck;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.CheckerDispatcher;
import org.sonar.java.se.Flow;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;

@Rule(key="DEBUG-SE-MethodYields", name="DEBUG(SE): Method yields", description="Display method yields produced for each method explored by the Symbolic Execution engine.", priority=Priority.INFO, tags={"debug"})
public class DebugMethodYieldsCheck
extends SECheck
implements DebugCheck {
    private Deque<IdentifierTree> methodNames = new LinkedList<IdentifierTree>();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.methodNames.push(methodTree.simpleName());
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        MethodBehavior mb = ((CheckerDispatcher)context).methodBehavior();
        IdentifierTree methodName = this.methodNames.pop();
        if (mb != null) {
            this.reportIssue(methodName, String.format("Method '%s' has %d method yields.", methodName.name(), mb.yields().size()), DebugMethodYieldsCheck.flowFromYield(mb, methodName));
        }
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.methodNames.pop();
    }

    private static Set<Flow> flowFromYield(MethodBehavior mb, IdentifierTree methodName) {
        Flow.Builder builder = Flow.builder();
        mb.yields().stream().map(yield -> new JavaFileScannerContext.Location(yield.toString(), methodName)).forEach(builder::add);
        return Collections.singleton(builder.build());
    }
}

