/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

public class AlwaysTrueOrFalseExpressionCollector {
    private final Multimap<Tree, ExplodedGraph.Node> falseEvaluations = HashMultimap.create();
    private final Multimap<Tree, ExplodedGraph.Node> trueEvaluations = HashMultimap.create();

    void evaluatedToFalse(Tree condition, ExplodedGraph.Node node) {
        this.falseEvaluations.put((Object)condition, (Object)node);
    }

    void evaluatedToTrue(Tree condition, ExplodedGraph.Node node) {
        this.trueEvaluations.put((Object)condition, (Object)node);
    }

    public Set<Tree> alwaysTrue() {
        return Sets.difference((Set)this.trueEvaluations.keySet(), (Set)this.falseEvaluations.keySet());
    }

    public Set<Tree> alwaysFalse() {
        return Sets.difference((Set)this.falseEvaluations.keySet(), (Set)this.trueEvaluations.keySet());
    }

    public Set<Flow> flowForExpression(Tree expression) {
        Collection<ExplodedGraph.Node> nodes = this.getNodes(expression);
        return AlwaysTrueOrFalseExpressionCollector.collectFlow(nodes);
    }

    private Collection<ExplodedGraph.Node> getNodes(Tree expression) {
        Collection falseNodes = this.falseEvaluations.get((Object)expression);
        return falseNodes.isEmpty() ? this.trueEvaluations.get((Object)expression) : falseNodes;
    }

    private static Set<Flow> collectFlow(Collection<ExplodedGraph.Node> nodes) {
        return nodes.stream().map(AlwaysTrueOrFalseExpressionCollector::flowFromNode).flatMap(Collection::stream).filter(f -> !f.isEmpty()).collect(Collectors.toSet());
    }

    private static Set<Flow> flowFromNode(ExplodedGraph.Node node) {
        ArrayList domains = Lists.newArrayList((Object[])new Class[]{ObjectConstraint.class, BooleanConstraint.class});
        return FlowComputation.flow(node.parent(), node.programState.peekValue(), domains, node.programState.peekValueSymbol().symbol);
    }

    public static Flow addIssueLocation(Flow flow, Tree issueTree, boolean conditionIsAlwaysTrue) {
        return Flow.builder().add(new JavaFileScannerContext.Location("Expression is always " + conditionIsAlwaysTrue + ".", issueTree)).addAll(flow).build();
    }

    public static boolean hasUnreachableCode(Tree booleanExpr, boolean isTrue) {
        Tree parent = AlwaysTrueOrFalseExpressionCollector.biggestTreeWithSameEvaluation(booleanExpr, isTrue);
        if (parent.is(Tree.Kind.IF_STATEMENT)) {
            IfStatementTree ifStatementTree = (IfStatementTree)parent;
            return !isTrue || ifStatementTree.elseStatement() != null;
        }
        if (parent.is(Tree.Kind.WHILE_STATEMENT) && !isTrue) {
            return true;
        }
        return parent.is(Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    private static Tree biggestTreeWithSameEvaluation(Tree booleanExpr, boolean isTrue) {
        Tree child = booleanExpr;
        Tree parent = booleanExpr.parent();
        while (AlwaysTrueOrFalseExpressionCollector.isBiggerTreeWithSameTruthiness(parent, child, isTrue)) {
            child = parent;
            parent = parent.parent();
        }
        Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)"Error getting parent tree with same evaluation, parent is null");
        return parent;
    }

    private static boolean isBiggerTreeWithSameTruthiness(@Nullable Tree parent, Tree child, boolean isTrue) {
        if (parent == null) {
            return false;
        }
        if (parent.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            return true;
        }
        Tree.Kind operator = isTrue ? Tree.Kind.CONDITIONAL_OR : Tree.Kind.CONDITIONAL_AND;
        return parent.is(operator) && ((BinaryExpressionTree)parent).leftOperand() == child;
    }
}

