/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;

public class SymbolMetadataResolve
implements SymbolMetadata {
    private List<SymbolMetadata.AnnotationInstance> annotations = Lists.newArrayList();

    SymbolMetadataResolve() {
    }

    @Override
    public List<SymbolMetadata.AnnotationInstance> annotations() {
        return this.annotations;
    }

    public List<Symbol> metaAnnotations() {
        return this.metaAnnotations(new HashSet<Type>());
    }

    private List<Symbol> metaAnnotations(Set<Type> knownTypes) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (SymbolMetadata.AnnotationInstance annotationInstance : this.annotations) {
            Symbol annotationSymbol = annotationInstance.symbol();
            Type annotationType = annotationSymbol.type();
            if (knownTypes.contains(annotationType)) continue;
            knownTypes.add(annotationType);
            result.add(annotationSymbol);
            result.addAll(((SymbolMetadataResolve)annotationSymbol.metadata()).metaAnnotations(knownTypes));
        }
        return new ArrayList<Symbol>(result);
    }

    void addAnnotation(SymbolMetadata.AnnotationInstance annotationInstance) {
        this.annotations.add(annotationInstance);
    }

    @Override
    public boolean isAnnotatedWith(String fullyQualifiedName) {
        for (SymbolMetadata.AnnotationInstance annotationInstance : this.annotations) {
            if (!annotationInstance.symbol().type().is(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    public List<SymbolMetadata.AnnotationValue> valuesForAnnotation(String fullyQualifiedNameOfAnnotation) {
        for (SymbolMetadata.AnnotationInstance annotationInstance : this.annotations) {
            if (!annotationInstance.symbol().type().is(fullyQualifiedNameOfAnnotation)) continue;
            return annotationInstance.values();
        }
        return null;
    }
}

