/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.JavaSymbol;

public class Scope {
    final JavaSymbol owner;
    final Scope next;
    protected ArrayListMultimap<String, JavaSymbol> symbols = ArrayListMultimap.create();
    protected final List<JavaSymbol> scopeSymbols = new ArrayList<JavaSymbol>();

    public Scope(JavaSymbol owner) {
        this.owner = owner;
        this.next = null;
    }

    public Scope(Scope next) {
        this.owner = next.owner;
        this.next = next;
    }

    public void enter(JavaSymbol symbol) {
        if (!symbol.isMethodSymbol() && this.symbols.containsKey((Object)symbol.name)) {
            for (JavaSymbol symInScope : this.symbols.get((Object)symbol.name)) {
                Preconditions.checkState((symInScope.kind != symbol.kind ? 1 : 0) != 0, (String)"Registering symbol: '%s' twice in the same scope", (Object[])new Object[]{symbol.name});
            }
        }
        this.symbols.put((Object)symbol.name, (Object)symbol);
        this.scopeSymbols.add(symbol);
    }

    public List<JavaSymbol> lookup(String name) {
        Scope scope = this;
        while (scope != null && !scope.symbols.containsKey((Object)name)) {
            scope = scope.next;
        }
        return scope == null ? ImmutableList.of() : scope.symbols.get((Object)name);
    }

    public List<JavaSymbol> scopeSymbols() {
        return this.scopeSymbols;
    }

    public static class StaticStarImportScope
    extends ImportScope {
        private final BytecodeCompleter bytecodeCompleter;

        public StaticStarImportScope(JavaSymbol owner, BytecodeCompleter bytecodeCompleter) {
            super(owner);
            this.bytecodeCompleter = bytecodeCompleter;
        }

        @Override
        public List<JavaSymbol> lookup(String name) {
            ArrayList symbolsList = Lists.newArrayList();
            for (JavaSymbol site : this.symbols.values()) {
                if ((site.kind & 1) != 0) {
                    JavaSymbol symbol2 = this.bytecodeCompleter.loadClass(this.bytecodeCompleter.formFullName(name, site));
                    if (symbol2.kind < 64) {
                        symbolsList.add(symbol2);
                    }
                }
                if ((site.kind & 2) == 0 || site.kind >= 64) continue;
                List<JavaSymbol> resolved = ((JavaSymbol.TypeJavaSymbol)site).members().lookup(name);
                resolved.stream().filter(symbol -> symbol.kind < 64 && Flags.isFlagged(symbol.flags, 8)).forEach(symbolsList::add);
            }
            return symbolsList;
        }
    }

    public static class StarImportScope
    extends ImportScope {
        private final BytecodeCompleter bytecodeCompleter;

        public StarImportScope(JavaSymbol owner, BytecodeCompleter bytecodeCompleter) {
            super(owner);
            this.bytecodeCompleter = bytecodeCompleter;
        }

        @Override
        public List<JavaSymbol> lookup(String name) {
            ArrayList symbolsList = Lists.newArrayList();
            for (JavaSymbol site : this.symbols.values()) {
                JavaSymbol symbol = this.bytecodeCompleter.loadClass(this.bytecodeCompleter.formFullName(name, site));
                if (symbol.kind >= 64) continue;
                symbolsList.add(symbol);
            }
            return symbolsList;
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(JavaSymbol owner) {
            super(owner);
        }

        @Override
        public void enter(JavaSymbol symbol) {
            this.symbols.put((Object)symbol.name, (Object)symbol);
            this.scopeSymbols.add(symbol);
        }
    }
}

