/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.sonar.java.resolve.AnnotationInstanceResolve;
import org.sonar.java.resolve.AnnotationValueResolve;
import org.sonar.java.resolve.BytecodeVisitor;
import org.sonar.java.resolve.JavaSymbol;

public class BytecodeAnnotationVisitor
extends AnnotationVisitor {
    private final AnnotationInstanceResolve annotationInstance;
    private final BytecodeVisitor bytecodeVisitor;

    public BytecodeAnnotationVisitor(AnnotationInstanceResolve annotationInstance, BytecodeVisitor bytecodeVisitor) {
        super(327680);
        this.annotationInstance = annotationInstance;
        this.bytecodeVisitor = bytecodeVisitor;
    }

    private void addValue(String name, Object value) {
        this.annotationInstance.addValue(new AnnotationValueResolve(name, value));
    }

    public void visit(String name, Object value) {
        this.addValue(name, value);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        JavaSymbol.TypeJavaSymbol annotationSymbol = this.getSymbol(desc);
        return new BytecodeAnnotationVisitor(new AnnotationInstanceResolve(annotationSymbol), this.bytecodeVisitor);
    }

    public void visitEnum(String name, String desc, String value) {
        JavaSymbol.TypeJavaSymbol sym = this.getSymbol(desc);
        if (sym.completing) {
            sym.callbackOnceComplete(() -> this.addSymbolAsValue(name, value, sym));
            return;
        }
        this.addSymbolAsValue(name, value, sym);
    }

    private void addSymbolAsValue(String name, String value, JavaSymbol.TypeJavaSymbol sym) {
        sym.members().lookup(value).stream().filter(symbol -> symbol.isKind(4)).forEach(symbol -> this.addValue(name, symbol));
    }

    public AnnotationVisitor visitArray(final String name) {
        final ArrayList valuesList = Lists.newArrayList();
        return new AnnotationVisitor(327680, this){

            public void visit(String name2, Object value) {
                valuesList.add(value);
            }

            public void visitEnum(String name2, String desc, String value) {
                BytecodeAnnotationVisitor.this.getSymbol(desc).members().lookup(value).stream().filter(symbol -> symbol.isKind(4)).forEach(valuesList::add);
            }

            public void visitEnd() {
                BytecodeAnnotationVisitor.this.addValue(name, valuesList.toArray());
            }
        };
    }

    private JavaSymbol.TypeJavaSymbol getSymbol(String desc) {
        return this.bytecodeVisitor.convertAsmType(Type.getType((String)desc)).getSymbol();
    }
}

