/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.JavaSquid;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.VariableReadExtractor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.ucfg.Expression;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;
import org.sonar.ucfg.UCFG;
import org.sonar.ucfg.UCFGBuilder;
import org.sonar.ucfg.UCFGtoProtobuf;

public class UCFGJavaVisitor
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOG = Loggers.get(JavaSquid.class);
    private final File protobufDirectory;
    String fileKey;
    private int index = 0;

    public UCFGJavaVisitor(File workdir) {
        this.protobufDirectory = new File(new File(workdir, "ucfg"), "java");
        if (this.protobufDirectory.exists()) {
            this.index = this.protobufDirectory.list().length;
        } else {
            this.protobufDirectory.mkdirs();
        }
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.fileKey = context.getFileKey();
        if (context.getSemanticModel() == null) {
            return;
        }
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        Symbol.MethodSymbol methodSymbol = tree.symbol();
        ArrayList<Type> types = new ArrayList<Type>(methodSymbol.parameterTypes());
        if (!tree.is(Tree.Kind.CONSTRUCTOR)) {
            types.add(methodSymbol.returnType().type());
        }
        if (tree.block() != null && types.stream().noneMatch(Type::isUnknown)) {
            CFG cfg = CFG.build(tree);
            this.serializeUCFG(tree, cfg);
        }
    }

    @VisibleForTesting
    protected void serializeUCFG(MethodTree tree, CFG cfg) {
        try {
            UCFG uCFG = this.buildUCfg(tree, cfg);
            UCFGtoProtobuf.toProtobufFile((UCFG)uCFG, (String)this.filePath());
        }
        catch (Exception e) {
            String msg = String.format("Cannot generate ucfg in file %s for method at line %d", this.fileKey, tree.firstToken().line());
            LOG.error(msg, (Throwable)e);
            throw new AnalysisException(msg, e);
        }
    }

    private String filePath() {
        String absolutePath = new File(this.protobufDirectory, "ucfg_" + this.index + ".proto").getAbsolutePath();
        ++this.index;
        return absolutePath;
    }

    private UCFG buildUCfg(MethodTree methodTree, CFG cfg) {
        String signature = UCFGJavaVisitor.signatureFor(methodTree.symbol());
        IdentifierGenerator idGenerator = new IdentifierGenerator(methodTree);
        UCFGBuilder builder = UCFGBuilder.createUCFGForMethod((String)signature);
        methodTree.parameters().stream().map(p -> idGenerator.lookupIdFor(p.symbol())).map(UCFGBuilder::variableWithId).forEach(arg_0 -> ((UCFGBuilder)builder).addMethodParam(arg_0));
        UCFGBuilder.BlockBuilder entryBlockBuilder = this.buildBasicBlock(cfg.entry(), methodTree, idGenerator);
        if (UCFGJavaVisitor.getAnnotatedStringParameters(methodTree).count() > 0L) {
            builder.addStartingBlock(this.buildParameterAnnotationsBlock(methodTree, idGenerator, cfg));
            builder.addBasicBlock(entryBlockBuilder);
        } else {
            builder.addStartingBlock(entryBlockBuilder);
        }
        cfg.blocks().stream().filter(b -> !b.equals(cfg.entry())).forEach(b -> builder.addBasicBlock(this.buildBasicBlock((CFG.Block)b, methodTree, idGenerator)));
        return builder.build();
    }

    private UCFGBuilder.BlockBuilder buildParameterAnnotationsBlock(MethodTree methodTree, IdentifierGenerator idGenerator, CFG cfg) {
        LocationInFile parametersLocation = this.location(methodTree.openParenToken(), methodTree.closeParenToken());
        UCFGBuilder.BlockBuilder blockBuilder = UCFGBuilder.newBasicBlock((String)"paramAnnotations", (LocationInFile)parametersLocation);
        UCFGJavaVisitor.getAnnotatedStringParameters(methodTree).forEach(parameter -> this.buildBlockForParameter((VariableTree)parameter, blockBuilder, idGenerator));
        Label nextBlockLabel = UCFGBuilder.createLabel((String)Integer.toString(cfg.entry().id()));
        blockBuilder.jumpTo(new Label[]{nextBlockLabel});
        return blockBuilder;
    }

    private void buildBlockForParameter(VariableTree parameter, UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator) {
        Expression.Variable parameterVariable = UCFGBuilder.variableWithId((String)idGenerator.lookupIdFor(parameter.symbol()));
        List<AnnotationTree> annotationList = parameter.modifiers().annotations();
        ArrayList annotationVariables = new ArrayList();
        annotationList.forEach(annotationTree -> {
            Expression.Variable var = UCFGBuilder.variableWithId((String)idGenerator.newIdFor((Tree)annotationTree));
            annotationVariables.add(var);
            blockBuilder.assignTo(var, UCFGBuilder.call((String)annotationTree.annotationType().symbolType().fullyQualifiedName()).withArgs(new Expression[]{parameterVariable}), this.location((Tree)annotationTree));
        });
        Expression[] args = annotationVariables.toArray(new Expression[annotationVariables.size()]);
        blockBuilder.assignTo(parameterVariable, UCFGBuilder.call((String)"__annotation").withArgs(args), this.location(parameter.simpleName()));
    }

    private static Stream<VariableTree> getAnnotatedStringParameters(MethodTree methodTree) {
        return methodTree.parameters().stream().filter(parameter -> UCFGJavaVisitor.isString(parameter.type().symbolType())).filter(parameter -> !parameter.modifiers().annotations().isEmpty());
    }

    private UCFGBuilder.BlockBuilder buildBasicBlock(CFG.Block javaBlock, MethodTree methodTree, IdentifierGenerator idGenerator) {
        UCFGBuilder.BlockBuilder blockBuilder = UCFGBuilder.newBasicBlock((String)String.valueOf(javaBlock.id()), (LocationInFile)this.location(javaBlock));
        javaBlock.elements().forEach(e -> this.buildCall((Tree)e, blockBuilder, idGenerator));
        Tree terminator = javaBlock.terminator();
        if (terminator != null && terminator.is(Tree.Kind.RETURN_STATEMENT)) {
            ExpressionTree returnedExpression = ((ReturnStatementTree)terminator).expression();
            Expression.Constant retExpr = UCFGBuilder.constant((String)"\"\"");
            if (methodTree.returnType() != null && UCFGJavaVisitor.isString(methodTree.returnType().symbolType())) {
                retExpr = idGenerator.lookupExpressionFor(returnedExpression);
            }
            blockBuilder.ret((Expression)retExpr, this.location(terminator));
            return blockBuilder;
        }
        Set<CFG.Block> successors = javaBlock.successors();
        if (!successors.isEmpty()) {
            blockBuilder.jumpTo((Label[])successors.stream().map(b -> UCFGBuilder.createLabel((String)Integer.toString(b.id()))).toArray(Label[]::new));
            return blockBuilder;
        }
        Preconditions.checkState((javaBlock.id() == 0 ? 1 : 0) != 0);
        blockBuilder.ret((Expression)UCFGBuilder.constant((String)"implicit return"), this.location(methodTree.lastToken()));
        return blockBuilder;
    }

    private void buildCall(Tree element, UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator) {
        if (UCFGJavaVisitor.isStringVarDecl(element)) {
            VariableTree variableTree = (VariableTree)element;
            String lhs = idGenerator.lookupIdFor(variableTree.simpleName());
            if (!idGenerator.isConst(lhs)) {
                ExpressionTree initializer = variableTree.initializer();
                String source = idGenerator.lookupIdFor(initializer);
                blockBuilder.assignTo(UCFGBuilder.variableWithId((String)lhs), UCFGBuilder.call((String)"__id").withArgs(new Expression[]{UCFGBuilder.variableWithId((String)source)}), this.location(element));
            }
            return;
        }
        if (element.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)element;
            this.buildMethodInvocation(blockBuilder, idGenerator, methodInvocationTree);
        } else if (element.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree newClassTree = (NewClassTree)element;
            this.buildConstructorInvocation(blockBuilder, idGenerator, newClassTree);
        } else if (element.is(Tree.Kind.PLUS, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.ASSIGNMENT) && UCFGJavaVisitor.isString(((ExpressionTree)element).symbolType())) {
            if (element.is(Tree.Kind.PLUS)) {
                BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)element;
                Expression lhs = idGenerator.lookupExpressionFor(binaryExpressionTree.leftOperand());
                Expression rhs = idGenerator.lookupExpressionFor(binaryExpressionTree.rightOperand());
                Expression.Variable var = UCFGBuilder.variableWithId((String)idGenerator.newIdFor(binaryExpressionTree));
                blockBuilder.assignTo(var, UCFGBuilder.call((String)"__concat").withArgs(new Expression[]{lhs, rhs}), this.location(element));
            } else if (element.is(Tree.Kind.PLUS_ASSIGNMENT)) {
                Expression var = idGenerator.lookupExpressionFor(((AssignmentExpressionTree)element).variable());
                Expression expr = idGenerator.lookupExpressionFor(((AssignmentExpressionTree)element).expression());
                if (!var.isConstant()) {
                    idGenerator.varForExpression(element, ((Expression.Variable)var).id());
                    blockBuilder.assignTo((Expression.Variable)var, UCFGBuilder.call((String)"__concat").withArgs(new Expression[]{var, expr}), this.location(element));
                }
            } else if (element.is(Tree.Kind.ASSIGNMENT)) {
                Expression var = idGenerator.lookupExpressionFor(((AssignmentExpressionTree)element).variable());
                Expression expr = idGenerator.lookupExpressionFor(((AssignmentExpressionTree)element).expression());
                if (!var.isConstant()) {
                    blockBuilder.assignTo((Expression.Variable)var, UCFGBuilder.call((String)"__id").withArgs(new Expression[]{expr}), this.location(element));
                }
            }
        }
    }

    private void buildConstructorInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, NewClassTree tree) {
        Symbol constructorSymbol = tree.constructorSymbol();
        if (!constructorSymbol.isMethodSymbol()) {
            return;
        }
        if (UCFGJavaVisitor.isString(constructorSymbol.owner().type()) || tree.arguments().stream().map(ExpressionTree::symbolType).anyMatch(UCFGJavaVisitor::isString)) {
            List<Expression> arguments = UCFGJavaVisitor.argumentIds(idGenerator, tree.arguments());
            this.buildAssignCall(blockBuilder, idGenerator, arguments, tree, (Symbol.MethodSymbol)constructorSymbol);
        }
    }

    private void buildMethodInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, MethodInvocationTree tree) {
        if (tree.symbol().isUnknown()) {
            return;
        }
        List<Object> arguments = null;
        if (UCFGJavaVisitor.isString(tree.symbol().owner().type())) {
            arguments = new ArrayList();
            if (tree.methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
                arguments.add(idGenerator.lookupExpressionFor(((MemberSelectExpressionTree)tree.methodSelect()).expression()));
            }
            arguments.addAll(UCFGJavaVisitor.argumentIds(idGenerator, tree.arguments()));
        } else if (UCFGJavaVisitor.isString(tree.symbolType()) || tree.arguments().stream().map(ExpressionTree::symbolType).anyMatch(UCFGJavaVisitor::isString)) {
            arguments = UCFGJavaVisitor.argumentIds(idGenerator, tree.arguments());
        }
        if (arguments != null) {
            this.buildAssignCall(blockBuilder, idGenerator, arguments, tree, (Symbol.MethodSymbol)tree.symbol());
        }
    }

    private void buildAssignCall(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, List<Expression> arguments, Tree tree, Symbol.MethodSymbol symbol) {
        String destination = idGenerator.newIdFor(tree);
        blockBuilder.assignTo(UCFGBuilder.variableWithId((String)destination), UCFGBuilder.call((String)UCFGJavaVisitor.signatureFor(symbol)).withArgs(arguments.toArray(new Expression[0])), this.location(tree));
    }

    private static List<Expression> argumentIds(IdentifierGenerator idGenerator, Arguments arguments) {
        return arguments.stream().map(idGenerator::lookupExpressionFor).collect(Collectors.toList());
    }

    private static String signatureFor(Symbol.MethodSymbol methodSymbol) {
        return ((JavaSymbol.MethodJavaSymbol)methodSymbol).completeSignature();
    }

    @Nullable
    private LocationInFile location(CFG.Block javaBlock) {
        Tree firstTree = null;
        List<Tree> elements = javaBlock.elements();
        if (!elements.isEmpty()) {
            firstTree = elements.get(0);
        } else if (javaBlock.terminator() != null) {
            firstTree = javaBlock.terminator();
        }
        if (firstTree == null) {
            return null;
        }
        return this.location(firstTree);
    }

    private LocationInFile location(Tree tree) {
        return this.location(tree.firstToken(), tree.lastToken());
    }

    private LocationInFile location(SyntaxToken firstToken, SyntaxToken lastToken) {
        return new LocationInFile(this.fileKey, firstToken.line(), firstToken.column(), lastToken.line(), lastToken.column() + lastToken.text().length());
    }

    private static boolean isStringVarDecl(Tree tree) {
        if (!tree.is(Tree.Kind.VARIABLE)) {
            return false;
        }
        VariableTree var = (VariableTree)tree;
        return UCFGJavaVisitor.isString(var.type().symbolType());
    }

    private static boolean isString(Type type) {
        return type.is("java.lang.String");
    }

    public static class IdentifierGenerator {
        private static final String CONST = "\"\"";
        private final Map<Symbol, String> vars;
        private final Map<Tree, String> temps;
        private int counter;

        public IdentifierGenerator(MethodTree methodTree) {
            List parameters = methodTree.parameters().stream().map(VariableTree::symbol).collect(Collectors.toList());
            VariableReadExtractor variableReadExtractor = new VariableReadExtractor(methodTree.symbol(), false);
            methodTree.accept(variableReadExtractor);
            Set locals = variableReadExtractor.usedVariables().stream().filter(s -> s.type().is("java.lang.String")).collect(Collectors.toSet());
            this.vars = Sets.union(new HashSet(parameters), locals).stream().collect(Collectors.toMap(s -> s, Symbol::name));
            this.temps = new HashMap<Tree, String>();
            this.counter = 0;
        }

        public boolean isConst(String id) {
            return CONST.equals(id);
        }

        public String newIdFor(@Nullable Tree tree) {
            String id = this.lookupIdFor(tree);
            if (this.isConst(id)) {
                return this.temps.computeIfAbsent(tree, t -> this.newId());
            }
            return id;
        }

        private String newId() {
            String result = "%" + this.counter;
            ++this.counter;
            return result;
        }

        public Expression lookupExpressionFor(@Nullable Tree tree) {
            String id = this.lookupIdFor(tree);
            if (this.isConst(id)) {
                if (tree != null && tree.is(Tree.Kind.STRING_LITERAL)) {
                    return UCFGBuilder.constant((String)LiteralUtils.trimQuotes(((LiteralTree)tree).value()));
                }
                return UCFGBuilder.constant((String)id);
            }
            return UCFGBuilder.variableWithId((String)id);
        }

        public String lookupIdFor(@Nullable Tree tree) {
            if (tree == null) {
                return CONST;
            }
            if (tree.is(Tree.Kind.IDENTIFIER)) {
                return this.lookupIdFor(((IdentifierTree)tree).symbol());
            }
            return this.temps.getOrDefault(tree, CONST);
        }

        public String lookupIdFor(Symbol symbol) {
            return this.vars.getOrDefault(symbol, CONST);
        }

        public void varForExpression(Tree element, String id) {
            this.temps.put(element, id);
        }
    }
}

