/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.ce.measure.RangeDistributionBuilder;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.java.ast.visitors.CognitiveComplexityVisitor;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.java.ast.visitors.StatementVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class Measurer
extends SubscriptionVisitor {
    private static final Number[] LIMITS_COMPLEXITY_METHODS = new Number[]{1, 2, 4, 6, 8, 10, 12};
    private static final Number[] LIMITS_COMPLEXITY_FILES = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final FileSystem fs;
    private final SensorContext sensorContext;
    private final NoSonarFilter noSonarFilter;
    private InputFile sonarFile;
    private int methods;
    private int complexityInMethods;
    private RangeDistributionBuilder methodComplexityDistribution;
    private final Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private int classes;

    public Measurer(FileSystem fs, SensorContext context, NoSonarFilter noSonarFilter) {
        this.fs = fs;
        this.sensorContext = context;
        this.noSonarFilter = noSonarFilter;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.CLASS), (Object)((Object)Tree.Kind.INTERFACE), (Object)((Object)Tree.Kind.ENUM), (Object)((Object)Tree.Kind.ANNOTATION_TYPE), (Object)((Object)Tree.Kind.NEW_CLASS), (Object)((Object)Tree.Kind.ENUM_CONSTANT), (Object)((Object)Tree.Kind.METHOD), (Object)((Object)Tree.Kind.CONSTRUCTOR));
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.sonarFile = this.fs.inputFile(this.fs.predicates().is(context.getFile()));
        CommentLinesVisitor commentLinesVisitor = this.createCommentLineVisitorAndFindNoSonar(context);
        if (this.isSonarLintContext()) {
            return;
        }
        this.classTrees.clear();
        this.methods = 0;
        this.complexityInMethods = 0;
        this.classes = 0;
        this.methodComplexityDistribution = new RangeDistributionBuilder(LIMITS_COMPLEXITY_METHODS);
        super.scanFile(context);
        int fileComplexity = context.getComplexityNodes(context.getTree()).size();
        this.saveMetricOnFile(CoreMetrics.CLASSES, this.classes);
        this.saveMetricOnFile(CoreMetrics.FUNCTIONS, this.methods);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_FUNCTIONS, this.complexityInMethods);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_CLASSES, fileComplexity);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY, fileComplexity);
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, commentLinesVisitor.commentLinesMetric());
        this.saveMetricOnFile(CoreMetrics.STATEMENTS, new StatementVisitor().numberOfStatements(context.getTree()));
        this.saveMetricOnFile(CoreMetrics.NCLOC, new LinesOfCodeVisitor().linesOfCode(context.getTree()));
        this.saveMetricOnFile(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, this.methodComplexityDistribution.build());
        RangeDistributionBuilder fileComplexityDistribution = new RangeDistributionBuilder(LIMITS_COMPLEXITY_FILES);
        this.saveMetricOnFile(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, fileComplexityDistribution.add((Number)fileComplexity).build());
        this.saveMetricOnFile(CoreMetrics.COGNITIVE_COMPLEXITY, CognitiveComplexityVisitor.compilationUnitComplexity(context.getTree()));
    }

    private boolean isSonarLintContext() {
        return this.sensorContext.runtime().getProduct() == SonarProduct.SONARLINT;
    }

    private CommentLinesVisitor createCommentLineVisitorAndFindNoSonar(JavaFileScannerContext context) {
        CommentLinesVisitor commentLinesVisitor = new CommentLinesVisitor();
        commentLinesVisitor.analyzeCommentLines(context.getTree());
        this.noSonarFilter.noSonarInFile(this.sonarFile, commentLinesVisitor.noSonarLines());
        return commentLinesVisitor;
    }

    @Override
    public void visitNode(Tree tree) {
        if (Measurer.isClassTree(tree)) {
            ++this.classes;
            this.classTrees.push((ClassTree)tree);
        }
        if (tree.is(Tree.Kind.NEW_CLASS) && ((NewClassTree)tree).classBody() != null) {
            --this.classes;
        }
        if (tree.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR) && this.classTrees.peek().simpleName() != null) {
            MethodTree methodTree = (MethodTree)tree;
            ++this.methods;
            int methodComplexity = this.context.getComplexityNodes(methodTree).size();
            this.methodComplexityDistribution.add((Number)methodComplexity);
            this.complexityInMethods += methodComplexity;
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (Measurer.isClassTree(tree)) {
            this.classTrees.pop();
        }
    }

    private static boolean isClassTree(Tree tree) {
        return tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.INTERFACE) || tree.is(Tree.Kind.ENUM) || tree.is(Tree.Kind.ANNOTATION_TYPE);
    }

    private <T extends Serializable> void saveMetricOnFile(Metric<T> metric, T value) {
        this.sensorContext.newMeasure().forMetric(metric).on((InputComponent)this.sonarFile).withValue(value).save();
    }

    public class TestFileMeasurer
    implements JavaFileScanner {
        @Override
        public void scanFile(JavaFileScannerContext context) {
            Measurer.this.sonarFile = Measurer.this.fs.inputFile(Measurer.this.fs.predicates().is(context.getFile()));
            Measurer.this.createCommentLineVisitorAndFindNoSonar(context);
        }
    }
}

