/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeSubstitutionSolver;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;

public class ParametrizedTypeCache {
    private Map<JavaSymbol, Map<TypeSubstitution, ParametrizedTypeJavaType>> typeCache = new HashMap<JavaSymbol, Map<TypeSubstitution, ParametrizedTypeJavaType>>();
    private Map<JavaType, Map<WildCardType.BoundType, WildCardType>> wildcardCache = new HashMap<JavaType, Map<WildCardType.BoundType, WildCardType>>();
    private TypeSubstitutionSolver typeSubstitutionSolver;

    public JavaType getParametrizedTypeType(JavaSymbol.TypeJavaSymbol symbol, TypeSubstitution typeSubstitution) {
        TypeSubstitution newSubstitution;
        if (symbol.getType().isUnknown()) {
            return symbol.getType();
        }
        if (this.typeCache.get(symbol) == null) {
            HashMap map = new HashMap();
            this.typeCache.put(symbol, map);
        }
        if ((newSubstitution = typeSubstitution).size() == 0) {
            newSubstitution = ParametrizedTypeCache.identitySubstitution(symbol.typeVariableTypes);
        }
        if (this.typeCache.get(symbol).get(newSubstitution) == null) {
            this.typeCache.get(symbol).put(newSubstitution, new ParametrizedTypeJavaType(symbol, newSubstitution, this.typeSubstitutionSolver));
        }
        return this.typeCache.get(symbol).get(newSubstitution);
    }

    private static TypeSubstitution identitySubstitution(List<TypeVariableJavaType> typeVariables) {
        TypeSubstitution result = new TypeSubstitution();
        for (TypeVariableJavaType typeVar : typeVariables) {
            result.add(typeVar, typeVar);
        }
        return result;
    }

    public JavaType getWildcardType(JavaType bound, WildCardType.BoundType boundType) {
        Map map = this.wildcardCache.computeIfAbsent(bound, b -> new EnumMap(WildCardType.BoundType.class));
        return map.computeIfAbsent(boundType, bt -> new WildCardType(bound, (WildCardType.BoundType)((Object)bt)));
    }

    public void setTypeSubstitutionSolver(TypeSubstitutionSolver typeSubstitutionSolver) {
        this.typeSubstitutionSolver = typeSubstitutionSolver;
    }
}

