/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Type;

public class ClassJavaType
extends JavaType {
    JavaType supertype;
    List<JavaType> interfaces;

    public ClassJavaType(JavaSymbol.TypeJavaSymbol symbol) {
        this(10, symbol);
    }

    protected ClassJavaType(int tag, JavaSymbol.TypeJavaSymbol symbol) {
        super(tag, symbol);
    }

    @Override
    public boolean is(String fullyQualifiedName) {
        return this.isTagged(13) || fullyQualifiedName.equals(this.symbol.getFullyQualifiedName());
    }

    @Override
    public boolean isSubtypeOf(String fullyQualifiedName) {
        return this.isTagged(13) || this.is(fullyQualifiedName) || this.superTypeContains(fullyQualifiedName);
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        if (this.isTagged(13)) {
            return ((JavaType)superType).isTagged(13) || superType.isClass() || superType.isArray();
        }
        if (((JavaType)superType).isTagged(16)) {
            return ((WildCardType)superType).isSubtypeOfBound(this);
        }
        if (superType.isClass()) {
            ClassJavaType superClassType = (ClassJavaType)superType;
            return this.equals(superClassType) || this.superTypeIsSubTypeOf(superClassType);
        }
        return false;
    }

    private boolean superTypeIsSubTypeOf(ClassJavaType superClassType) {
        for (ClassJavaType classType : this.symbol.directSuperTypes()) {
            if (!classType.isSubtypeOf(superClassType)) continue;
            return true;
        }
        return false;
    }

    private boolean superTypeContains(String fullyQualifiedName) {
        for (ClassJavaType classType : this.symbol.superTypes()) {
            if (!classType.is(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ClassJavaType> directSuperTypes() {
        ImmutableSet.Builder types = ImmutableSet.builder();
        ClassJavaType superClassType = this.getSuperType();
        if (superClassType != null) {
            types.add((Object)superClassType);
        }
        for (JavaType interfaceType : this.symbol.getInterfaces()) {
            types.add((Object)this.substitutedType((ClassJavaType)interfaceType));
        }
        return types.build();
    }

    @Override
    @CheckForNull
    public ClassJavaType getSuperType() {
        ClassJavaType type = (ClassJavaType)this.symbol.superClass();
        if (type == null) {
            return null;
        }
        return this.substitutedType(type);
    }

    protected ClassJavaType substitutedType(ClassJavaType type) {
        return type;
    }

    public Set<ClassJavaType> superTypes() {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (ClassJavaType classJavaType : this.directSuperTypes()) {
            types.add((Object)classJavaType);
            types.addAll(classJavaType.superTypes());
        }
        return types.build();
    }
}

