/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(List<? extends Tree> leftList, List<? extends Tree> rightList) {
        if (leftList.size() != rightList.size()) {
            return false;
        }
        for (int i = 0; i < leftList.size(); ++i) {
            Tree right;
            Tree left = leftList.get(i);
            if (SyntacticEquivalence.areEquivalent(left, right = rightList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable Tree leftNode, @Nullable Tree rightNode) {
        return SyntacticEquivalence.areEquivalent((JavaTree)leftNode, (JavaTree)rightNode);
    }

    private static boolean areEquivalent(@Nullable JavaTree leftNode, @Nullable JavaTree rightNode) {
        if (leftNode == rightNode) {
            return true;
        }
        if (leftNode == null || rightNode == null) {
            return false;
        }
        if (leftNode.kind() != rightNode.kind() || leftNode.is(Tree.Kind.OTHER)) {
            return false;
        }
        if (leftNode.isLeaf()) {
            return SyntacticEquivalence.areLeafsEquivalent(leftNode, rightNode);
        }
        Iterator<Tree> iteratorA = leftNode.getChildren().iterator();
        Iterator<Tree> iteratorB = rightNode.getChildren().iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(iteratorA.next(), iteratorB.next())) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    private static boolean areLeafsEquivalent(JavaTree leftNode, JavaTree rightNode) {
        if (leftNode instanceof SyntaxToken) {
            return Objects.equals(((SyntaxToken)((Object)leftNode)).text(), ((SyntaxToken)((Object)rightNode)).text());
        }
        if (leftNode.is(Tree.Kind.INFERED_TYPE)) {
            return rightNode.is(Tree.Kind.INFERED_TYPE);
        }
        throw new IllegalArgumentException();
    }
}

