/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.PrintWriter;
import java.io.StringWriter;

public class AnalysisError {
    private final String message;
    private final String cause;
    private final String filename;
    private final Kind kind;

    public AnalysisError(Exception exception, String filename, Kind kind) {
        this.message = exception.getMessage() == null ? "" : exception.getMessage();
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        this.cause = sw.toString();
        this.filename = filename;
        this.kind = kind;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCause() {
        return this.cause;
    }

    public String getFilename() {
        return this.filename;
    }

    public Kind getKind() {
        return this.kind;
    }

    public int serializedSize() {
        return this.message.length() + this.cause.length() + this.filename.length() + this.kind.name().length();
    }

    public static enum Kind {
        PARSE_ERROR,
        SEMANTIC_ERROR,
        CHECK_ERROR,
        SE_ERROR;

    }
}

