/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.bluetoothemulation.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v138.bluetoothemulation.model.CharacteristicOperationType;
import org.openqa.selenium.devtools.v138.bluetoothemulation.model.CharacteristicWriteType;
import org.openqa.selenium.json.JsonInput;

public class CharacteristicOperationReceived {
    private final String characteristicId;
    private final CharacteristicOperationType type;
    private final Optional<String> data;
    private final Optional<CharacteristicWriteType> writeType;

    public CharacteristicOperationReceived(String characteristicId, CharacteristicOperationType type, Optional<String> data, Optional<CharacteristicWriteType> writeType) {
        this.characteristicId = Objects.requireNonNull(characteristicId, "characteristicId is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.data = data;
        this.writeType = writeType;
    }

    public String getCharacteristicId() {
        return this.characteristicId;
    }

    public CharacteristicOperationType getType() {
        return this.type;
    }

    public Optional<String> getData() {
        return this.data;
    }

    public Optional<CharacteristicWriteType> getWriteType() {
        return this.writeType;
    }

    private static CharacteristicOperationReceived fromJson(JsonInput input) {
        String characteristicId = null;
        CharacteristicOperationType type = null;
        Optional<String> data = Optional.empty();
        Optional<CharacteristicWriteType> writeType = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "characteristicId": {
                    characteristicId = input.nextString();
                    continue block12;
                }
                case "type": {
                    type = (CharacteristicOperationType)((Object)input.read(CharacteristicOperationType.class));
                    continue block12;
                }
                case "data": {
                    data = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "writeType": {
                    writeType = Optional.ofNullable((CharacteristicWriteType)((Object)input.read(CharacteristicWriteType.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CharacteristicOperationReceived(characteristicId, type, data, writeType);
    }
}

