/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v114.css.model.CSSProperty;
import org.openqa.selenium.devtools.v114.css.model.ShorthandEntry;
import org.openqa.selenium.devtools.v114.css.model.SourceRange;
import org.openqa.selenium.devtools.v114.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class CSSStyle {
    private final Optional<StyleSheetId> styleSheetId;
    private final List<CSSProperty> cssProperties;
    private final List<ShorthandEntry> shorthandEntries;
    private final Optional<String> cssText;
    private final Optional<SourceRange> range;

    public CSSStyle(Optional<StyleSheetId> styleSheetId, List<CSSProperty> cssProperties, List<ShorthandEntry> shorthandEntries, Optional<String> cssText, Optional<SourceRange> range) {
        this.styleSheetId = styleSheetId;
        this.cssProperties = Objects.requireNonNull(cssProperties, "cssProperties is required");
        this.shorthandEntries = Objects.requireNonNull(shorthandEntries, "shorthandEntries is required");
        this.cssText = cssText;
        this.range = range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public List<CSSProperty> getCssProperties() {
        return this.cssProperties;
    }

    public List<ShorthandEntry> getShorthandEntries() {
        return this.shorthandEntries;
    }

    public Optional<String> getCssText() {
        return this.cssText;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    private static CSSStyle fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        List cssProperties = null;
        List shorthandEntries = null;
        Optional<String> cssText = Optional.empty();
        Optional<SourceRange> range = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block14;
                }
                case "cssProperties": {
                    cssProperties = (List)input.read(new TypeToken<List<CSSProperty>>(){}.getType());
                    continue block14;
                }
                case "shorthandEntries": {
                    shorthandEntries = (List)input.read(new TypeToken<List<ShorthandEntry>>(){}.getType());
                    continue block14;
                }
                case "cssText": {
                    cssText = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSStyle(styleSheetId, cssProperties, shorthandEntries, cssText, range);
    }
}

