/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v105.network.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v105.network.model.Headers;
import org.openqa.selenium.devtools.v105.network.model.PostDataEntry;
import org.openqa.selenium.devtools.v105.network.model.ResourcePriority;
import org.openqa.selenium.devtools.v105.network.model.TrustTokenParams;
import org.openqa.selenium.devtools.v105.security.model.MixedContentType;
import org.openqa.selenium.json.JsonInput;

public class Request {
    private final String url;
    private final Optional<String> urlFragment;
    private final String method;
    private final Headers headers;
    private final Optional<String> postData;
    private final Optional<Boolean> hasPostData;
    private final Optional<List<PostDataEntry>> postDataEntries;
    private final Optional<MixedContentType> mixedContentType;
    private final ResourcePriority initialPriority;
    private final ReferrerPolicy referrerPolicy;
    private final Optional<Boolean> isLinkPreload;
    private final Optional<TrustTokenParams> trustTokenParams;
    private final Optional<Boolean> isSameSite;

    public Request(String url, Optional<String> urlFragment, String method, Headers headers, Optional<String> postData, Optional<Boolean> hasPostData, Optional<List<PostDataEntry>> postDataEntries, Optional<MixedContentType> mixedContentType, ResourcePriority initialPriority, ReferrerPolicy referrerPolicy, Optional<Boolean> isLinkPreload, Optional<TrustTokenParams> trustTokenParams, Optional<Boolean> isSameSite) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.method = Objects.requireNonNull(method, "method is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.postData = postData;
        this.hasPostData = hasPostData;
        this.postDataEntries = postDataEntries;
        this.mixedContentType = mixedContentType;
        this.initialPriority = Objects.requireNonNull(initialPriority, "initialPriority is required");
        this.referrerPolicy = Objects.requireNonNull(referrerPolicy, "referrerPolicy is required");
        this.isLinkPreload = isLinkPreload;
        this.trustTokenParams = trustTokenParams;
        this.isSameSite = isSameSite;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getUrlFragment() {
        return this.urlFragment;
    }

    public String getMethod() {
        return this.method;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Optional<String> getPostData() {
        return this.postData;
    }

    public Optional<Boolean> getHasPostData() {
        return this.hasPostData;
    }

    @Beta
    public Optional<List<PostDataEntry>> getPostDataEntries() {
        return this.postDataEntries;
    }

    public Optional<MixedContentType> getMixedContentType() {
        return this.mixedContentType;
    }

    public ResourcePriority getInitialPriority() {
        return this.initialPriority;
    }

    public ReferrerPolicy getReferrerPolicy() {
        return this.referrerPolicy;
    }

    public Optional<Boolean> getIsLinkPreload() {
        return this.isLinkPreload;
    }

    @Beta
    public Optional<TrustTokenParams> getTrustTokenParams() {
        return this.trustTokenParams;
    }

    @Beta
    public Optional<Boolean> getIsSameSite() {
        return this.isSameSite;
    }

    private static Request fromJson(JsonInput input) {
        String url = null;
        Optional<String> urlFragment = Optional.empty();
        String method = null;
        Headers headers = null;
        Optional<String> postData = Optional.empty();
        Optional<Boolean> hasPostData = Optional.empty();
        Optional<List<PostDataEntry>> postDataEntries = Optional.empty();
        Optional<MixedContentType> mixedContentType = Optional.empty();
        ResourcePriority initialPriority = null;
        ReferrerPolicy referrerPolicy = null;
        Optional<Boolean> isLinkPreload = Optional.empty();
        Optional<TrustTokenParams> trustTokenParams = Optional.empty();
        Optional<Boolean> isSameSite = Optional.empty();
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block30;
                }
                case "urlFragment": {
                    urlFragment = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "method": {
                    method = input.nextString();
                    continue block30;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block30;
                }
                case "postData": {
                    postData = Optional.ofNullable(input.nextString());
                    continue block30;
                }
                case "hasPostData": {
                    hasPostData = Optional.ofNullable(input.nextBoolean());
                    continue block30;
                }
                case "postDataEntries": {
                    postDataEntries = Optional.ofNullable((List)input.read(new TypeToken<List<PostDataEntry>>(){}.getType()));
                    continue block30;
                }
                case "mixedContentType": {
                    mixedContentType = Optional.ofNullable((MixedContentType)((Object)input.read(MixedContentType.class)));
                    continue block30;
                }
                case "initialPriority": {
                    initialPriority = (ResourcePriority)((Object)input.read(ResourcePriority.class));
                    continue block30;
                }
                case "referrerPolicy": {
                    referrerPolicy = ReferrerPolicy.fromString(input.nextString());
                    continue block30;
                }
                case "isLinkPreload": {
                    isLinkPreload = Optional.ofNullable(input.nextBoolean());
                    continue block30;
                }
                case "trustTokenParams": {
                    trustTokenParams = Optional.ofNullable((TrustTokenParams)input.read(TrustTokenParams.class));
                    continue block30;
                }
                case "isSameSite": {
                    isSameSite = Optional.ofNullable(input.nextBoolean());
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Request(url, urlFragment, method, headers, postData, hasPostData, postDataEntries, mixedContentType, initialPriority, referrerPolicy, isLinkPreload, trustTokenParams, isSameSite);
    }

    public static enum ReferrerPolicy {
        UNSAFE_URL("unsafe-url"),
        NO_REFERRER_WHEN_DOWNGRADE("no-referrer-when-downgrade"),
        NO_REFERRER("no-referrer"),
        ORIGIN("origin"),
        ORIGIN_WHEN_CROSS_ORIGIN("origin-when-cross-origin"),
        SAME_ORIGIN("same-origin"),
        STRICT_ORIGIN("strict-origin"),
        STRICT_ORIGIN_WHEN_CROSS_ORIGIN("strict-origin-when-cross-origin");

        private String value;

        private ReferrerPolicy(String value) {
            this.value = value;
        }

        public static ReferrerPolicy fromString(String s) {
            return Arrays.stream(ReferrerPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ReferrerPolicy "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static ReferrerPolicy fromJson(JsonInput input) {
            return ReferrerPolicy.fromString(input.nextString());
        }
    }
}

