/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SharedCapabilitiesMethods;
import org.openqa.selenium.internal.Require;

public class PersistentCapabilities
implements Capabilities {
    private final ImmutableCapabilities caps;
    private final ImmutableCapabilities overrides;
    private final int hashCode;

    public PersistentCapabilities() {
        this(new ImmutableCapabilities());
    }

    public PersistentCapabilities(Capabilities source) {
        this(source, new ImmutableCapabilities());
    }

    private PersistentCapabilities(Capabilities previousValues, Capabilities newValues) {
        Require.nonNull("Source capabilities", previousValues, "may be empty, but must be set.", new Object[0]);
        Require.nonNull("Additional capabilities", newValues, "may be empty, but must be set.", new Object[0]);
        this.caps = ImmutableCapabilities.copyOf(previousValues);
        this.overrides = ImmutableCapabilities.copyOf(newValues);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public PersistentCapabilities setCapability(String name, Object value) {
        Require.nonNull("Name", name);
        Require.nonNull("Value", value);
        return new PersistentCapabilities(this, new ImmutableCapabilities(name, value));
    }

    @Override
    public Map<String, Object> asMap() {
        return this.getCapabilityNames().stream().collect(this.toUnmodifiableMap(Function.identity(), this::getCapability));
    }

    @Override
    public Object getCapability(String capabilityName) {
        Require.nonNull("Capability name", capabilityName);
        Object capability = this.overrides.getCapability(capabilityName);
        if (capability != null) {
            return capability;
        }
        return this.caps.getCapability(capabilityName);
    }

    @Override
    public Capabilities merge(Capabilities other) {
        Require.nonNull("Other capabilities", other, "may be empty, but must be set.", new Object[0]);
        return new PersistentCapabilities(this, other);
    }

    @Override
    public Set<String> getCapabilityNames() {
        return Stream.concat(this.caps.getCapabilityNames().stream(), this.overrides.getCapabilityNames().stream()).collect(this.toUnmodifiableSet());
    }

    private <T, K, U> Collector<T, ?, Map<K, U>> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toMap(keyMapper, valueMapper), Collections::unmodifiableMap);
    }

    private <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }

    public String toString() {
        return SharedCapabilitiesMethods.toString(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Capabilities)) {
            return false;
        }
        return SharedCapabilitiesMethods.equals(this, (Capabilities)o);
    }
}

