/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveHyperLogLogCommands
extends RedissonBaseReactive
implements ReactiveHyperLogLogCommands {
    private static final RedisCommand<Long> PFADD = new RedisCommand("PFADD");
    private static final RedisStrictCommand<String> PFMERGE = new RedisStrictCommand("PFMERGE");

    RedissonReactiveHyperLogLogCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfAddCommand, Long>> pfAdd(Publisher<ReactiveHyperLogLogCommands.PfAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty((Collection)command.getValues(), (String)"Values must not be empty!");
            byte[] keyBuf = RedissonReactiveHyperLogLogCommands.toByteArray(command.getKey());
            ArrayList<byte[]> params = new ArrayList<byte[]>(command.getValues().size() + 1);
            params.add(keyBuf);
            params.addAll(command.getValues().stream().map(v -> RedissonReactiveHyperLogLogCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, PFADD, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfCountCommand, Long>> pfCount(Publisher<ReactiveHyperLogLogCommands.PfCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notEmpty((Collection)command.getKeys(), (String)"Keys must not be empty!");
            Object[] args = command.getKeys().stream().map(v -> RedissonReactiveHyperLogLogCommands.toByteArray(v)).toArray();
            Mono m = this.write((byte[])args[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.PFCOUNT, args);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHyperLogLogCommands.PfMergeCommand>> pfMerge(Publisher<ReactiveHyperLogLogCommands.PfMergeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null!");
            byte[] keyBuf = RedissonReactiveHyperLogLogCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getSourceKeys().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getSourceKeys().stream().map(v -> RedissonReactiveHyperLogLogCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)PFMERGE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse(command, Boolean.valueOf(true)));
        });
    }
}

