/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.ScanPackages;
import org.rapidoid.beany.Metadata;
import org.rapidoid.cls.Cls;
import org.rapidoid.ioc.Manage;
import org.rapidoid.ioc.Wired;
import org.rapidoid.u.U;
import org.rapidoid.util.MscOpts;

public class ClassMetadata
extends RapidoidThing {
    public static final List<Class<? extends Annotation>> INJECTION_ANNOTATIONS = U.list((Object[])new Class[]{Wired.class, Resource.class, Inject.class});
    public final Class<?> clazz;
    public final Set<Field> injectableFields;
    public final Set<Constructor<?>> injectableConstructors;
    public final Constructor<?> defaultConstructor;
    public final Set<Class<?>> typesToManage;
    public final Set<String> packagesToScan;

    public ClassMetadata(Class<?> clazz) {
        this.clazz = clazz;
        this.injectableFields = Collections.synchronizedSet(ClassMetadata.getInjectableFields(clazz));
        this.injectableConstructors = Collections.synchronizedSet(ClassMetadata.getInjectableConstructors(clazz));
        this.defaultConstructor = ClassMetadata.getDefaultConstructor(clazz);
        this.typesToManage = Collections.synchronizedSet(ClassMetadata.getTypesToManage(clazz));
        this.packagesToScan = Collections.synchronizedSet(this.getPackagesToScan(clazz));
    }

    public static Set<Class<?>> getTypesToManage(Class<?> clazz) {
        Set types = U.set();
        Manage depAnn = (Manage)Metadata.getAnnotationRecursive(clazz, Manage.class);
        if (depAnn != null) {
            Collections.addAll(types, depAnn.value());
        }
        return types;
    }

    private Set<String> getPackagesToScan(Class<?> clazz) {
        ScanPackages scan = (ScanPackages)Metadata.getAnnotationRecursive(clazz, ScanPackages.class);
        if (scan != null) {
            Object[] pkgs = scan.value();
            U.must((boolean)U.notEmpty((Object[])pkgs), (String)"@ScanPackages requires a list of packages to scan!");
            return U.set((Object[])pkgs);
        }
        return U.set();
    }

    public static Set<Field> getInjectableFields(Class<?> clazz) {
        Set fields = U.set();
        for (Class<? extends Annotation> annotation : INJECTION_ANNOTATIONS) {
            fields.addAll(Cls.getFieldsAnnotated(clazz, annotation));
        }
        if (MscOpts.hasJPA()) {
            Class javaxPersistenceContext = Cls.get((String)"javax.persistence.PersistenceContext");
            List emFields = Cls.getFieldsAnnotated(clazz, (Class)javaxPersistenceContext);
            for (Field emField : emFields) {
                U.must((boolean)emField.getType().getName().equals("javax.persistence.EntityManager"), (String)"Expected EntityManager type!");
            }
            fields.addAll(emFields);
        }
        return fields;
    }

    public static Set<Constructor<?>> getInjectableConstructors(Class<?> clazz) {
        Set constructors = U.set();
        for (Constructor<?> constr : clazz.getDeclaredConstructors()) {
            if (!Metadata.hasAny((Annotation[])constr.getAnnotations(), INJECTION_ANNOTATIONS)) continue;
            constructors.add(constr);
        }
        return constructors;
    }

    public static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

