/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Window;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.plugins.MapImporterProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.pepsoft.worldpainter.util.FileUtils;
import org.pepsoft.worldpainter.util.MinecraftUtil;

public final class MapUtils {
    static final PlatformProvider.MapInfo NOT_A_MAP = new PlatformProvider.MapInfo(null, null, null, null, -1, -1);

    private MapUtils() {
    }

    public static PlatformProvider.MapInfo selectMap(Window parent, File defaultDir) {
        PlatformManager platformManager;
        Hashtable<File, PlatformProvider.MapInfo> mapInfoCache;
        File selectedFile;
        File mySavesDir;
        File file = mySavesDir = defaultDir != null ? defaultDir : Configuration.getInstance().getSavesDirectory();
        if (mySavesDir == null && MinecraftUtil.findMinecraftDir() != null) {
            mySavesDir = new File(MinecraftUtil.findMinecraftDir(), "saves");
        }
        if ((selectedFile = FileUtils.selectDirectoryForOpen(parent, "Select an existing map directory", mySavesDir, "Map Directories", new FileView(mapInfoCache = new Hashtable<File, PlatformProvider.MapInfo>(), platformManager = PlatformManager.getInstance()){
            final /* synthetic */ Map val$mapInfoCache;
            final /* synthetic */ PlatformManager val$platformManager;
            {
                this.val$mapInfoCache = map;
                this.val$platformManager = platformManager;
            }

            @Override
            public String getName(File f) {
                return null;
            }

            @Override
            public String getDescription(File f) {
                PlatformProvider.MapInfo mapInfo = MapUtils.getMapInfo(f, this.val$mapInfoCache, this.val$platformManager);
                return mapInfo != NOT_A_MAP ? mapInfo.name : null;
            }

            @Override
            public String getTypeDescription(File f) {
                PlatformProvider.MapInfo mapInfo = MapUtils.getMapInfo(f, this.val$mapInfoCache, this.val$platformManager);
                return mapInfo != NOT_A_MAP ? mapInfo.platform.displayName : null;
            }

            @Override
            public Icon getIcon(File f) {
                PlatformProvider.MapInfo mapInfo = MapUtils.getMapInfo(f, this.val$mapInfoCache, this.val$platformManager);
                return mapInfo != NOT_A_MAP ? mapInfo.icon : null;
            }

            @Override
            public Boolean isTraversable(File f) {
                return MapUtils.getMapInfo(f, this.val$mapInfoCache, this.val$platformManager) != NOT_A_MAP ? Boolean.FALSE : null;
            }
        })) != null) {
            PlatformProvider.MapInfo mapInfo = MapUtils.getMapInfo(selectedFile, mapInfoCache, platformManager);
            return mapInfo != NOT_A_MAP ? mapInfo : null;
        }
        return null;
    }

    static PlatformProvider.MapInfo getMapInfo(File dir, Map<File, PlatformProvider.MapInfo> mapInfoCache, PlatformManager platformManager) {
        return mapInfoCache.computeIfAbsent(dir, key -> {
            PlatformProvider platformProvider;
            PlatformProvider.MapInfo mapInfo = platformManager.identifyMap(dir);
            if (mapInfo != null && (platformProvider = platformManager.getPlatformProvider(mapInfo.platform)) instanceof MapImporterProvider) {
                return mapInfo;
            }
            return NOT_A_MAP;
        });
    }
}

