/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.LifoBlockingDeque;

public class LazyLoadingIconToggleButton
extends JToggleButton {
    private final Supplier<Icon> iconSupplier;
    private State state = State.NOT_LOADED;
    private static final ExecutorService iconLoader = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LifoBlockingDeque());
    private static final Map<Integer, Icon> emptyIcons = new HashMap<Integer, Icon>();

    public LazyLoadingIconToggleButton(int size, Supplier<Icon> iconSupplier) {
        super(LazyLoadingIconToggleButton.getEmptyIcon(size));
        Objects.requireNonNull(iconSupplier);
        this.iconSupplier = iconSupplier;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.state == State.NOT_LOADED) {
            this.state = State.LOADING;
            iconLoader.submit(() -> {
                Icon icon = this.iconSupplier.get();
                AwtUtils.doOnEventThread(() -> {
                    this.setIcon(icon);
                    this.state = State.LOADED;
                });
            });
        }
        super.paintComponent(g);
    }

    private static Icon getEmptyIcon(final int size) {
        return emptyIcons.computeIfAbsent(size, key -> new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return size;
            }

            @Override
            public int getIconHeight() {
                return size;
            }
        });
    }

    static enum State {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

