/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import com.google.common.collect.ImmutableSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.imageio.ImageIO;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImageUtils.class);

    private ImageUtils() {
    }

    public static BufferedImage loadImage(Component parent, File file) {
        if (file.isFile() && file.canRead()) {
            logger.info("Loading image");
            try {
                return ImageIO.read(file);
            }
            catch (IOException e) {
                logger.error("I/O error while loading image " + file, (Throwable)e);
                MessageUtils.beepAndShowError((Component)parent, (String)"An error occurred while loading the image.\nIt may not be a valid or supported image file, or the file may be corrupted.", (String)"Error Loading Image");
            }
            catch (Error | RuntimeException e) {
                logger.error(e.getClass().getSimpleName() + " while loading image " + file, e);
                MessageUtils.beepAndShowError((Component)parent, (String)"An error occurred while loading the image.\nThere may not be enough available memory, or the image may be too large.", (String)"Error Loading Image");
            }
        }
        return null;
    }

    public static File selectImageForOpen(Window parent, String imageType, File selectedFile) {
        return FileUtils.selectFileForOpen(parent, "Select " + imageType, selectedFile != null && selectedFile.exists() ? selectedFile : DesktopUtils.getPicturesFolder(), ImageUtils.getFileFilter());
    }

    public static File selectImageForSave(Window parent, String imageType, File selectedFile) {
        return FileUtils.selectFileForSave(parent, "Export as " + imageType, selectedFile != null && selectedFile.exists() ? selectedFile : DesktopUtils.getPicturesFolder(), ImageUtils.getFileFilter());
    }

    private static FileFilter getFileFilter() {
        ImmutableSet extensions = ImmutableSet.copyOf((Object[])ImageIO.getReaderFileSuffixes());
        StringBuilder sb = new StringBuilder("Supported image formats (");
        boolean first = true;
        for (String extension : extensions) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("*.");
            sb.append(extension);
        }
        sb.append(')');
        String description = sb.toString();
        return new FileFilter((Set)extensions, description){
            final /* synthetic */ Set val$extensions;
            final /* synthetic */ String val$description;
            {
                this.val$extensions = set;
                this.val$description = string;
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName();
                int p = filename.lastIndexOf(46);
                if (p != -1) {
                    String extension = filename.substring(p + 1).toLowerCase();
                    return this.val$extensions.contains(extension);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return this.val$description;
            }

            @Override
            public String getExtensions() {
                return String.join((CharSequence)";", this.val$extensions);
            }
        };
    }
}

