/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.JComponent;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.worldpainter.MouseAdapter;

public class IconEditor
extends JComponent {
    private BufferedImage icon;
    private int iconWidth;
    private int iconHeight;
    private int paintColour = -16777216;
    private int eraseColour = 0xFFFFFF;
    private boolean editable = true;
    private static final int PREFERRED_CELL_SIZE = Math.round(16.0f * GUIUtils.getUIScale()) + 1;

    public IconEditor() {
        this.setIcon(new BufferedImage(16, 16, 2));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IconEditor.this.mouseClicked(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                IconEditor.this.mouseDragged(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (IconEditor.this.editable) {
                    IconEditor.this.firePropertyChange("icon", null, IconEditor.this.icon);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public void setIcon(BufferedImage icon) {
        Objects.requireNonNull(icon);
        this.iconWidth = icon.getWidth();
        this.iconHeight = icon.getHeight();
        this.setMinimumSize(new Dimension(this.iconWidth * 2 + 1, this.iconHeight * 2 + 1));
        this.setPreferredSize(new Dimension(this.iconWidth * PREFERRED_CELL_SIZE + 1, this.iconHeight * PREFERRED_CELL_SIZE + 1));
        this.icon = icon;
        this.repaint();
    }

    public int getPaintColour() {
        return this.paintColour;
    }

    public void setPaintColour(int argb) {
        this.paintColour = argb;
    }

    public int getEraseColour() {
        return this.eraseColour;
    }

    public void setEraseColour(int eraseColour) {
        this.eraseColour = eraseColour;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void fill(int argb) {
        for (int x = 0; x < this.iconWidth; ++x) {
            for (int y = 0; y < this.iconHeight; ++y) {
                this.icon.setRGB(x, y, argb);
            }
        }
        this.repaint();
        this.firePropertyChange("icon", null, this.icon);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        int xCellSize = (width - 1) / this.iconWidth;
        int yCellSize = (height - 1) / this.iconHeight;
        g2.setColor(this.getForeground());
        for (x = 0; x <= this.iconWidth; ++x) {
            g2.drawLine(x * xCellSize, 0, x * xCellSize, height - 1);
        }
        for (int y = 0; y <= this.iconHeight; ++y) {
            g2.drawLine(0, y * yCellSize, width - 1, y * yCellSize);
        }
        for (x = 0; x < this.iconWidth; ++x) {
            for (int y = 0; y < this.iconHeight; ++y) {
                g2.setColor(new Color(this.icon.getRGB(x, y), true));
                g2.fillRect(x * xCellSize + 1, y * yCellSize + 1, xCellSize - 1, yCellSize - 1);
            }
        }
    }

    private void mouseClicked(MouseEvent e) {
        if (this.editable) {
            this.setPixel(e.getX(), e.getY(), e.getButton() == 1);
        }
    }

    private void mouseDragged(MouseEvent e) {
        if (this.editable) {
            this.setPixel(e.getX(), e.getY(), (e.getModifiersEx() & 0x400) != 0);
        }
    }

    private void setPixel(int xOnComponent, int yOnComponent, boolean set) {
        int xCellSize = (this.getWidth() - 1) / this.iconWidth;
        int yCellSize = (this.getHeight() - 1) / this.iconHeight;
        int x = xOnComponent / xCellSize;
        int y = yOnComponent / yCellSize;
        if (x >= 0 && x < this.iconWidth && y >= 0 && y < this.iconHeight) {
            this.icon.setRGB(x, y, set ? this.paintColour : this.eraseColour);
            this.repaint(new Rectangle(x * xCellSize + 1, y * yCellSize + 1, xCellSize - 1, yCellSize - 1));
        }
    }
}

