/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import com.jidesoft.docking.DockableFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IconUtils;

public class DockableFrameBuilder {
    private final String title;
    private final int side;
    private final int index;
    private final Component component;
    private String id;
    private boolean expand;
    private Icon icon;
    private int margin = 2;
    private boolean scrollable;
    private static final Icon ICON_UNKNOWN_PATTERN = IconUtils.loadScaledIcon((String)"org/pepsoft/worldpainter/icons/unknown_pattern.png");

    public DockableFrameBuilder(Component component, String title, int side, int index) {
        this.component = component;
        this.title = title;
        this.side = side;
        this.index = index;
        this.id = (Character.toLowerCase(title.charAt(0)) + title.substring(1)).replaceAll("\\s", "");
    }

    public DockableFrameBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public DockableFrameBuilder expand() {
        this.expand = true;
        return this;
    }

    public DockableFrameBuilder withIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public DockableFrameBuilder withMargin(int margin) {
        this.margin = margin;
        return this;
    }

    public DockableFrameBuilder scrollable() {
        this.scrollable = true;
        return this;
    }

    public DockableFrame build() {
        DockableFrame dockableFrame = new DockableFrame(this.id);
        VerticalScrollingJPanel panel = new VerticalScrollingJPanel(new GridBagLayout());
        if (this.margin > 0) {
            panel.setBorder(new EmptyBorder(this.margin, this.margin, this.margin, this.margin));
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        if (this.expand) {
            constraints.fill = 1;
            constraints.weighty = 1.0;
            panel.add(this.component, constraints);
        } else {
            constraints.fill = 2;
            panel.add(this.component, constraints);
            constraints.fill = 1;
            constraints.weighty = 1.0;
            panel.add((Component)new JPanel(), constraints);
        }
        if (this.scrollable) {
            JScrollPane scrollPane = new JScrollPane(panel, 20, 31);
            scrollPane.setBorder(null);
            dockableFrame.add((Component)scrollPane, (Object)"Center");
        } else {
            dockableFrame.add((Component)panel, (Object)"Center");
        }
        dockableFrame.setTitle(this.title);
        dockableFrame.setSideTitle(this.title);
        dockableFrame.setTabTitle(this.title);
        dockableFrame.setToolTipText(this.title);
        if (this.icon == null && this.component instanceof Container) {
            this.icon = DockableFrameBuilder.findIcon((Container)this.component);
            if (this.icon != null) {
                int desiredSize = Math.round(16.0f * GUIUtils.getUIScale());
                if ((this.icon.getIconHeight() > desiredSize || this.icon.getIconWidth() > desiredSize) && this.icon instanceof ImageIcon && ((ImageIcon)this.icon).getImage() instanceof BufferedImage) {
                    float s = this.icon.getIconWidth() > this.icon.getIconHeight() ? (float)desiredSize / (float)this.icon.getIconWidth() : (float)desiredSize / (float)this.icon.getIconHeight();
                    AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(s, s), 3);
                    BufferedImage iconImage = op.filter((BufferedImage)((ImageIcon)this.icon).getImage(), null);
                    this.icon = new ImageIcon(iconImage);
                }
            }
        }
        dockableFrame.setFrameIcon(this.icon != null ? this.icon : ICON_UNKNOWN_PATTERN);
        Dimension preferredSize = this.component.getPreferredSize();
        dockableFrame.setAutohideWidth(preferredSize.width);
        dockableFrame.setDockedWidth(preferredSize.width);
        dockableFrame.setDockedHeight(preferredSize.height);
        dockableFrame.setUndockedBounds(new Rectangle(-1, -1, preferredSize.width, preferredSize.height));
        dockableFrame.setHidable(true);
        dockableFrame.setAvailableButtons(14);
        dockableFrame.setShowContextMenu(false);
        dockableFrame.setInitMode(4);
        dockableFrame.setInitSide(this.side);
        dockableFrame.setInitIndex(this.index);
        dockableFrame.setAutohideWhenActive(true);
        dockableFrame.setMaximizable(false);
        dockableFrame.putClientProperty((Object)"org.pepsoft.worldpainter.helpKey", (Object)("Panel/" + this.id));
        return dockableFrame;
    }

    private static Icon findIcon(Container container) {
        Icon icon;
        if (container instanceof JComponent && (icon = (Icon)((JComponent)container).getClientProperty("org.pepsoft.worldpainter.icon")) != null) {
            return icon;
        }
        for (Component component : container.getComponents()) {
            Icon icon2;
            if (component instanceof AbstractButton && ((AbstractButton)component).getIcon() != null) {
                return ((AbstractButton)component).getIcon();
            }
            if (!(component instanceof Container) || (icon2 = DockableFrameBuilder.findIcon((Container)component)) == null) continue;
            return icon2;
        }
        return null;
    }

    static class VerticalScrollingJPanel
    extends JPanel
    implements Scrollable {
        public VerticalScrollingJPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 16;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

