/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class AKDockLayout
extends BorderLayout {
    private List<Component> north = new ArrayList<Component>(1);
    private List<Component> south = new ArrayList<Component>(1);
    private List<Component> east = new ArrayList<Component>(1);
    private List<Component> west = new ArrayList<Component>(1);
    private Component center = null;
    private int northHeight;
    private int southHeight;
    private int eastWidth;
    private int westWidth;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component c, Object con) {
        Object object = c.getTreeLock();
        synchronized (object) {
            if (con != null) {
                String s;
                switch (s = con.toString()) {
                    case "North": {
                        this.north.add(c);
                        break;
                    }
                    case "South": {
                        this.south.add(c);
                        break;
                    }
                    case "East": {
                        this.east.add(c);
                        break;
                    }
                    case "West": {
                        this.west.add(c);
                        break;
                    }
                    case "Center": {
                        this.center = c;
                    }
                }
                c.getParent().validate();
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component c) {
        this.north.remove(c);
        this.south.remove(c);
        this.east.remove(c);
        this.west.remove(c);
        if (c == this.center) {
            this.center = null;
        }
        this.flipSeparators(c, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            this.northHeight = this.getPreferredDimension(this.north).height;
            this.southHeight = this.getPreferredDimension(this.south).height;
            this.eastWidth = this.getPreferredDimension(this.east).width;
            this.westWidth = this.getPreferredDimension(this.west).width;
            this.placeComponents(target, this.north, left, top, right - left, this.northHeight, 1);
            this.placeComponents(target, this.south, left, bottom - this.southHeight, right - left, this.southHeight, 3);
            this.placeComponents(target, this.east, right - this.eastWidth, top += this.northHeight + this.getVgap(), this.eastWidth, (bottom -= this.southHeight + this.getVgap()) - top, 4);
            right -= this.eastWidth + this.getHgap();
            this.placeComponents(target, this.west, left, top, this.westWidth, bottom - top, 2);
            left += this.westWidth + this.getHgap();
            if (this.center != null) {
                this.center.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    private Dimension getPreferredDimension(List<Component> comps) {
        int w = 0;
        int h = 0;
        Iterator<Component> iterator = comps.iterator();
        while (iterator.hasNext()) {
            Component comp;
            Component c = comp = iterator.next();
            Dimension d = c.getPreferredSize();
            w = Math.max(w, d.width);
            h = Math.max(h, d.height);
        }
        return new Dimension(w, h);
    }

    private void placeComponents(Container target, List<Component> comps, int x, int y, int w, int h, int orientation) {
        int offset = 0;
        Component c = null;
        if (orientation == 1 || orientation == 3) {
            offset = x;
            int totalWidth = 0;
            for (int i = 0; i < comps.size(); ++i) {
                c = comps.get(i);
                this.flipSeparators(c, 1);
                int cwidth = c.getPreferredSize().width;
                if (w < (totalWidth += cwidth) && i != 0) {
                    offset = x;
                    if (orientation == 1) {
                        y += h;
                        this.northHeight += h;
                    } else if (orientation == 3) {
                        this.southHeight += h;
                        y -= h;
                    }
                    totalWidth = cwidth;
                }
                c.setBounds(x + offset, y, cwidth, h);
                offset += cwidth;
            }
            this.flipSeparators(c, 1);
        } else {
            int totalHeight = 0;
            for (int i = 0; i < comps.size(); ++i) {
                c = comps.get(i);
                int cheight = c.getPreferredSize().height;
                if (h < (totalHeight += cheight) && i != 0) {
                    if (orientation == 2) {
                        x += w;
                        this.westWidth += w;
                    } else if (orientation == 4) {
                        this.eastWidth += w;
                        x -= w;
                    }
                    totalHeight = cheight;
                    offset = 0;
                }
                if (totalHeight > h) {
                    cheight = h - 1;
                }
                c.setBounds(x, y + offset, w, cheight);
                offset += cheight;
            }
            this.flipSeparators(c, 0);
        }
    }

    private void flipSeparators(Component c, int orientn) {
        JToolBar jtb;
        Component[] comps;
        if (c != null && c instanceof JToolBar && UIManager.getLookAndFeel().getName().toLowerCase().indexOf("windows") != -1 && (comps = (jtb = (JToolBar)c).getComponents()) != null && comps.length > 0) {
            for (int i = 0; i < comps.length; ++i) {
                try {
                    Component component = comps[i];
                    if (component == null || !(component instanceof JSeparator)) continue;
                    jtb.remove(component);
                    JSeparator separ = new JSeparator();
                    if (orientn == 1) {
                        separ.setOrientation(1);
                        separ.setMinimumSize(new Dimension(2, 6));
                        separ.setPreferredSize(new Dimension(2, 6));
                        separ.setMaximumSize(new Dimension(2, 100));
                    } else {
                        separ.setOrientation(0);
                        separ.setMinimumSize(new Dimension(6, 2));
                        separ.setPreferredSize(new Dimension(6, 2));
                        separ.setMaximumSize(new Dimension(100, 2));
                    }
                    jtb.add((Component)separ, i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

