/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.ExceptionHandler;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonRun;
    private JButton buttonSelectScript;
    private JComboBox<File> comboBoxScript;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelName;
    private JPanel panelDescriptor;
    private JTextArea textAreaOutput;
    private JTextArea textAreaParameters;
    private final World2 world;
    private final Dimension dimension;
    private final ArrayList<File> recentScriptFiles;
    private final Collection<UndoManager> undoManagers;
    private ScriptDescriptor scriptDescriptor;
    private ScriptingContext context;
    private Timer nonResponsiveScriptWarningTimer;
    private static final ScriptEngineManager SCRIPT_ENGINE_MANAGER = new ScriptEngineManager();
    private static final Pattern DESCRIPTOR_PATTERN = Pattern.compile("script\\.([.a-zA-Z_0-9]+)=(.+)$");
    private static final Map<String, ScriptEngine> SCRIPT_ENGINES = new HashMap<String, ScriptEngine>();
    private static final Map<String, CompiledScript> COMPILED_SCRIPTS = new HashMap<String, CompiledScript>();
    private static final Logger logger = LoggerFactory.getLogger(ScriptRunner.class);

    public ScriptRunner(Window parent, World2 world, Dimension dimension, Collection<UndoManager> undoManagers) {
        super(parent);
        this.world = world;
        this.dimension = dimension;
        this.undoManagers = undoManagers;
        this.initComponents();
        Configuration config = Configuration.getInstance();
        this.recentScriptFiles = config.getRecentScriptFiles() != null ? new ArrayList(config.getRecentScriptFiles()) : new ArrayList();
        this.recentScriptFiles.removeIf(file -> !file.isFile());
        this.comboBoxScript.setModel(new DefaultComboBoxModel<File>(this.recentScriptFiles.toArray(new File[this.recentScriptFiles.size()])));
        if (this.comboBoxScript.getSelectedItem() != null && ((File)this.comboBoxScript.getSelectedItem()).isFile()) {
            this.setupScript((File)this.comboBoxScript.getSelectedItem());
        }
        this.setControlStates();
        this.getRootPane().setDefaultButton(this.buttonRun);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void setControlStates() {
        this.buttonRun.setEnabled(this.comboBoxScript.getSelectedItem() != null && ((File)this.comboBoxScript.getSelectedItem()).isFile() && (this.scriptDescriptor == null || this.scriptDescriptor.isValid()));
    }

    private void selectFile() {
        final HashSet extensions = new HashSet();
        SCRIPT_ENGINE_MANAGER.getEngineFactories().forEach(factory -> extensions.addAll(factory.getExtensions()));
        File script = FileUtils.selectFileForOpen(this, "Select Script", (File)this.comboBoxScript.getSelectedItem(), new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int p = name.lastIndexOf(46);
                if (p >= 0) {
                    return extensions.contains(name.substring(p + 1));
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Script files (" + extensions.stream().map(extension -> "*." + extension).collect(Collectors.joining(", ")) + ")";
            }

            @Override
            public String getExtensions() {
                return String.join((CharSequence)";", extensions);
            }
        });
        if (script != null && script.isFile()) {
            this.recentScriptFiles.remove(script);
            this.recentScriptFiles.add(0, script);
            this.comboBoxScript.setModel(new DefaultComboBoxModel<File>(this.recentScriptFiles.toArray(new File[this.recentScriptFiles.size()])));
            this.comboBoxScript.setSelectedItem(script);
            this.setupScript(script);
            this.setControlStates();
        }
    }

    private void setupScript(File script) {
        this.scriptDescriptor = this.analyseScript(script);
        while (this.panelDescriptor.getComponentCount() > 2) {
            this.panelDescriptor.remove(2);
        }
        if (this.scriptDescriptor != null) {
            if (this.scriptDescriptor.name != null) {
                this.labelName.setText(this.scriptDescriptor.name);
            } else {
                this.labelName.setText(script.getName());
            }
            if (this.scriptDescriptor.description != null) {
                this.addRegular(this.panelDescriptor, new JLabel("Description:"));
                JTextArea textArea = new JTextArea(this.scriptDescriptor.description);
                textArea.setEditable(false);
                textArea.setOpaque(false);
                this.addlastOnLine(this.panelDescriptor, textArea);
            }
            boolean allFieldsOptional = true;
            for (ParameterDescriptor<?, ?> paramDescriptor : this.scriptDescriptor.parameterDescriptors) {
                boolean showAsMandatory = !paramDescriptor.optional && (paramDescriptor instanceof FileParameterDescriptor || paramDescriptor instanceof FloatParameterDescriptor || paramDescriptor instanceof StringParameterDescriptor);
                JLabel label = new JLabel((paramDescriptor.displayName != null ? paramDescriptor.displayName : paramDescriptor.name) + (showAsMandatory ? "*:" : ":"));
                allFieldsOptional &= !showAsMandatory;
                Object editor = paramDescriptor.getEditor();
                label.setLabelFor((Component)editor);
                if (paramDescriptor.description != null) {
                    label.setToolTipText(paramDescriptor.description);
                }
                this.addRegular(this.panelDescriptor, label);
                if (paramDescriptor.description != null) {
                    ((JComponent)editor).setToolTipText(paramDescriptor.description);
                }
                this.addlastOnLine(this.panelDescriptor, (JComponent)editor);
                paramDescriptor.setChangeListener(e -> this.setControlStates());
            }
            if (!allFieldsOptional) {
                this.addlastOnLine(this.panelDescriptor, new JLabel("* mandatory parameter"));
            }
            this.jLabel2.setVisible(!this.scriptDescriptor.hideCmdLineParams);
            this.jLabel3.setVisible(!this.scriptDescriptor.hideCmdLineParams);
            this.jScrollPane1.setVisible(!this.scriptDescriptor.hideCmdLineParams);
        } else {
            this.labelName.setText(script.getName());
            this.jLabel2.setVisible(true);
            this.jLabel3.setVisible(true);
            this.jScrollPane1.setVisible(true);
        }
        this.pack();
    }

    private void addRegular(JPanel panel, JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)component, constraints);
    }

    private void addlastOnLine(JPanel panel, JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.insets = new Insets(3, 3, 3, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        panel.add((Component)component, constraints);
    }

    private ScriptDescriptor analyseScript(File script) {
        if (!script.isFile()) {
            return null;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (BufferedReader in = new BufferedReader(new FileReader(script));){
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith("#") || line.startsWith("//")) {
                    Matcher matcher;
                    if (line.startsWith("#") && line.substring(1).trim().startsWith("--") || line.startsWith("//") && line.substring(2).trim().startsWith("--") || !(matcher = DESCRIPTOR_PATTERN.matcher(line)).find()) continue;
                    properties.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading script " + script, e);
        }
        if (properties.isEmpty()) {
            return null;
        }
        ScriptDescriptor descriptor = new ScriptDescriptor();
        LinkedHashMap paramMap = new LinkedHashMap();
        properties.forEach((key, value) -> {
            if (key.equals("name")) {
                descriptor.name = value.trim();
            } else if (key.equals("description")) {
                descriptor.description = value.trim().replace("\\n", "\n");
            } else if (key.startsWith("param.")) {
                String[] parts = key.split("\\.");
                if (parts.length != 3) {
                    throw new IllegalArgumentException("Invalid key \"" + key + "\" in script descriptor");
                }
                ParameterDescriptor paramDescriptor = (ParameterDescriptor)paramMap.get(parts[1]);
                switch (parts[2]) {
                    case "type": {
                        if (paramDescriptor == null) {
                            switch (value.toLowerCase().trim()) {
                                case "string": {
                                    paramDescriptor = new StringParameterDescriptor();
                                    break;
                                }
                                case "integer": {
                                    paramDescriptor = new IntegerParameterDescriptor();
                                    break;
                                }
                                case "percentage": {
                                    paramDescriptor = new PercentageParameterDescriptor();
                                    break;
                                }
                                case "float": {
                                    paramDescriptor = new FloatParameterDescriptor();
                                    break;
                                }
                                case "file": {
                                    paramDescriptor = new FileParameterDescriptor();
                                    break;
                                }
                                case "boolean": {
                                    paramDescriptor = new BooleanParameterDescriptor();
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Invalid type \"" + value + "\" specified for parameter " + parts[1]);
                                }
                            }
                            paramDescriptor.name = parts[1];
                            paramMap.put(parts[1], paramDescriptor);
                            descriptor.parameterDescriptors.add(paramDescriptor);
                            break;
                        }
                        throw new IllegalArgumentException("Type specified more than once for parameter " + parts[1]);
                    }
                    case "description": {
                        paramDescriptor.description = value.replace("\\n", "\n");
                        break;
                    }
                    case "optional": {
                        paramDescriptor.optional = value.trim().isEmpty() || Boolean.parseBoolean(value.toLowerCase().trim());
                        break;
                    }
                    case "default": {
                        paramDescriptor.defaultValue = paramDescriptor.toObject(value.trim());
                        break;
                    }
                    case "displayName": {
                        paramDescriptor.displayName = value.trim();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid key \"" + key + "\" in script descriptor");
                    }
                }
            } else if (key.equals("hideCmdLineParams")) {
                descriptor.hideCmdLineParams = "true".equalsIgnoreCase(value.trim());
            } else {
                throw new IllegalArgumentException("Invalid key \"" + key + "\" in script descriptor");
            }
        });
        return descriptor;
    }

    private void run() {
        String scriptName;
        Map<String, Object> params;
        this.comboBoxScript.setEnabled(false);
        this.buttonSelectScript.setEnabled(false);
        this.textAreaParameters.setEnabled(false);
        this.buttonRun.setEnabled(false);
        this.buttonCancel.setText("Abort");
        this.textAreaOutput.setText(null);
        final File scriptFile = (File)this.comboBoxScript.getSelectedItem();
        final String scriptFilePath = scriptFile.getParentFile().getAbsolutePath();
        final String scriptFileName = scriptFile.getName();
        if (this.scriptDescriptor != null) {
            params = this.scriptDescriptor.getValues();
            scriptName = this.scriptDescriptor.name != null ? this.scriptDescriptor.name : scriptFileName;
        } else {
            params = null;
            scriptName = scriptFileName;
        }
        this.context = new ScriptingContext(false);
        new Thread(scriptFileName){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private /* synthetic */ void lambda$run$5() {
                if (ScriptRunner.this.nonResponsiveScriptWarningTimer != null) {
                    ScriptRunner.this.nonResponsiveScriptWarningTimer.stop();
                    ScriptRunner.this.nonResponsiveScriptWarningTimer = null;
                }
                ScriptRunner.this.comboBoxScript.setEnabled(true);
                ScriptRunner.this.buttonSelectScript.setEnabled(true);
                ScriptRunner.this.textAreaParameters.setEnabled(true);
                ScriptRunner.this.buttonRun.setEnabled(true);
                ScriptRunner.this.buttonCancel.setText("Close");
                ScriptRunner.this.buttonCancel.setEnabled(true);
            }

            private /* synthetic */ void lambda$run$4(String scriptFileName2) {
                MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)("I/O error while executing " + scriptFileName2), (String)"Error");
            }

            private /* synthetic */ void lambda$run$3(StringBuilder sb) {
                MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)sb.toString(), (String)"Error");
            }

            private /* synthetic */ void lambda$run$2(RuntimeException e) {
                MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)(e.getClass().getSimpleName() + " occurred (message: " + e.getMessage() + ")"), (String)"Error");
            }

            private /* synthetic */ void lambda$run$1() {
                MessageUtils.beepAndShowWarning((Component)ScriptRunner.this, (String)"Script execution interrupted by user", (String)"Script Aborted");
            }

            private /* synthetic */ void lambda$run$0(String extension) {
                MessageUtils.beepAndShowError((Component)ScriptRunner.this, (String)("No script engine installed for extension \"" + extension + "\""), (String)"Error");
            }
        }.start();
    }

    @Override
    protected void cancel() {
        if (this.context != null) {
            this.buttonCancel.setText("...");
            this.buttonCancel.setEnabled(false);
            this.context.interrupt();
            this.nonResponsiveScriptWarningTimer = new Timer(10000, evt -> MessageUtils.showWarning((Component)this, (String)"Script not responding to interrupt request.\nAsk the author to add interrupt checking to the script.\nSee the WorldPainter Scripting API docs for details.\nThe only way to stop the script may be to kill WorldPainter", (String)"Script Unresponsive"));
            this.nonResponsiveScriptWarningTimer.start();
        } else {
            super.cancel();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.comboBoxScript = new JComboBox();
        this.buttonSelectScript = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textAreaParameters = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.buttonRun = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.textAreaOutput = new JTextArea();
        this.buttonCancel = new JButton();
        this.panelDescriptor = new JPanel();
        this.jLabel5 = new JLabel();
        this.labelName = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Run Script");
        this.jLabel1.setText("Script:");
        this.comboBoxScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.comboBoxScriptActionPerformed(evt);
            }
        });
        this.buttonSelectScript.setText("...");
        this.buttonSelectScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.buttonSelectScriptActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Parameters:");
        this.textAreaParameters.setColumns(20);
        this.textAreaParameters.setRows(5);
        this.jScrollPane1.setViewportView(this.textAreaParameters);
        this.jLabel3.setText("(one per line)");
        this.jLabel4.setText("Output:");
        this.buttonRun.setText("Run");
        this.buttonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.buttonRunActionPerformed(evt);
            }
        });
        this.textAreaOutput.setEditable(false);
        this.textAreaOutput.setColumns(20);
        this.textAreaOutput.setLineWrap(true);
        this.textAreaOutput.setRows(5);
        this.textAreaOutput.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.textAreaOutput);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptRunner.this.buttonCancelActionPerformed(evt);
            }
        });
        this.panelDescriptor.setLayout(new GridBagLayout());
        this.jLabel5.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 1, 0, 2);
        this.panelDescriptor.add((Component)this.jLabel5, gridBagConstraints);
        this.labelName.setText("jLabel6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.panelDescriptor.add((Component)this.labelName, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxScript, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectScript)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 598, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.panelDescriptor, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboBoxScript, -2, -1, -2).addComponent(this.buttonSelectScript)).addGap(18, 18, 18).addComponent(this.panelDescriptor, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonRun).addComponent(this.buttonCancel)).addContainerGap()));
        this.pack();
    }

    private void buttonSelectScriptActionPerformed(ActionEvent evt) {
        this.selectFile();
    }

    private void buttonRunActionPerformed(ActionEvent evt) {
        this.run();
    }

    private void comboBoxScriptActionPerformed(ActionEvent evt) {
        this.setupScript((File)this.comboBoxScript.getSelectedItem());
        this.setControlStates();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    static class ScriptDescriptor {
        String name;
        String description;
        List<ParameterDescriptor<?, ?>> parameterDescriptors = new ArrayList();
        boolean hideCmdLineParams;

        ScriptDescriptor() {
        }

        boolean isValid() {
            return this.parameterDescriptors.stream().allMatch(p -> p.isEditorValid());
        }

        Map<String, Object> getValues() {
            HashMap<String, Object> values = new HashMap<String, Object>();
            this.parameterDescriptors.forEach(p -> {
                Object value = p.getValue();
                if (value != null) {
                    values.put(p.name, value);
                }
            });
            return values;
        }
    }

    static abstract class ParameterDescriptor<T, E extends JComponent> {
        String name;
        String description;
        String displayName;
        boolean optional;
        E editor;
        T defaultValue;
        private ChangeListener changeListener;

        ParameterDescriptor() {
        }

        E getEditor() {
            if (this.editor == null) {
                this.editor = this.createEditor();
            }
            if (this.defaultValue != null) {
                this.setValue(this.defaultValue);
            }
            return this.editor;
        }

        boolean isEditorValid() {
            return true;
        }

        abstract T getValue();

        abstract void setValue(T var1);

        abstract T toObject(String var1);

        ChangeListener getChangeListener() {
            return this.changeListener;
        }

        void setChangeListener(ChangeListener changeListener) {
            this.changeListener = changeListener;
        }

        protected abstract E createEditor();

        protected void notifyChangeListener() {
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    static class FileParameterDescriptor
    extends ParameterDescriptor<File, JPanel> {
        FileParameterDescriptor() {
        }

        @Override
        protected JPanel createEditor() {
            JPanel panel = new JPanel(new GridBagLayout()){

                @Override
                public int getBaseline(int width, int height) {
                    return this.getComponent(0).getBaseline(width, height);
                }
            };
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.fill = 2;
            JTextField field = new JTextField();
            field.setToolTipText(this.description);
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }
            });
            panel.add((Component)field, constraints);
            constraints.weightx = 0.0;
            constraints.gridwidth = 0;
            constraints.insets = new Insets(0, 3, 0, 0);
            JButton button = new JButton("...");
            button.setToolTipText(this.description);
            button.addActionListener(e -> {
                JFileChooser fileChooser = new JFileChooser();
                if (!field.getText().trim().isEmpty()) {
                    fileChooser.setSelectedFile(new File(field.getText().trim()));
                }
                if (ExceptionHandler.doWithoutExceptionReporting(() -> fileChooser.showOpenDialog(panel)) == 0) {
                    field.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            });
            panel.add((Component)button, constraints);
            return panel;
        }

        @Override
        File toObject(String str) {
            return new File(str);
        }

        @Override
        boolean isEditorValid() {
            if (this.optional) {
                return true;
            }
            String text = ((JTextField)((JPanel)this.editor).getComponent(0)).getText();
            return !text.trim().isEmpty() && new File(text.trim()).isFile();
        }

        @Override
        File getValue() {
            String text = ((JTextField)((JPanel)this.editor).getComponent(0)).getText();
            return text.trim().isEmpty() ? null : new File(text.trim());
        }

        @Override
        void setValue(File value) {
            ((JTextField)((JPanel)this.editor).getComponent(0)).setText(value.getAbsolutePath());
        }
    }

    static class FloatParameterDescriptor
    extends ParameterDescriptor<Float, JFormattedTextField> {
        FloatParameterDescriptor() {
        }

        @Override
        protected JFormattedTextField createEditor() {
            JFormattedTextField field = new JFormattedTextField(NumberFormat.getNumberInstance());
            field.setHorizontalAlignment(11);
            field.addPropertyChangeListener("value", e -> this.notifyChangeListener());
            return field;
        }

        @Override
        Float toObject(String str) {
            return Float.valueOf(str);
        }

        @Override
        boolean isEditorValid() {
            try {
                ((JFormattedTextField)this.editor).commitEdit();
                return this.optional || ((JFormattedTextField)this.editor).getValue() != null;
            }
            catch (ParseException e) {
                return this.optional;
            }
        }

        @Override
        Float getValue() {
            Number nr = (Number)((JFormattedTextField)this.editor).getValue();
            return nr != null ? Float.valueOf(nr.floatValue()) : null;
        }

        @Override
        void setValue(Float value) {
            ((JFormattedTextField)this.editor).setValue(value);
        }
    }

    static class StringParameterDescriptor
    extends ParameterDescriptor<String, JTextField> {
        StringParameterDescriptor() {
        }

        @Override
        protected JTextField createEditor() {
            JTextField field = new JTextField((String)this.defaultValue);
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.notifyChangeListener();
                }
            });
            return field;
        }

        @Override
        String toObject(String str) {
            return str;
        }

        @Override
        boolean isEditorValid() {
            return this.optional || !((JTextField)this.editor).getText().trim().isEmpty();
        }

        @Override
        String getValue() {
            String text = ((JTextField)this.editor).getText();
            return text.trim().isEmpty() ? null : text.trim();
        }

        @Override
        void setValue(String value) {
            ((JTextField)this.editor).setText(value);
        }
    }

    static class IntegerParameterDescriptor
    extends ParameterDescriptor<Integer, JSpinner> {
        IntegerParameterDescriptor() {
        }

        @Override
        protected JSpinner createEditor() {
            JSpinner spinner = new JSpinner();
            spinner.addChangeListener(e -> this.notifyChangeListener());
            return spinner;
        }

        @Override
        Integer toObject(String str) {
            return Integer.valueOf(str);
        }

        @Override
        Integer getValue() {
            return (Integer)((JSpinner)this.editor).getValue();
        }

        @Override
        void setValue(Integer value) {
            ((JSpinner)this.editor).setValue(value);
        }
    }

    static class PercentageParameterDescriptor
    extends ParameterDescriptor<Integer, JPanel> {
        PercentageParameterDescriptor() {
        }

        @Override
        protected JPanel createEditor() {
            JPanel panel = new JPanel(new GridBagLayout()){

                @Override
                public int getBaseline(int width, int height) {
                    return this.getComponent(0).getBaseline(width, height);
                }
            };
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.fill = 2;
            SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, 100, 1);
            JSpinner spinner = new JSpinner(spinnerModel);
            spinner.setToolTipText(this.description);
            spinner.addChangeListener(e -> this.notifyChangeListener());
            panel.add((Component)spinner, constraints);
            constraints.weightx = 0.0;
            constraints.gridwidth = 0;
            JLabel label = new JLabel("%");
            label.setToolTipText(this.description);
            panel.add((Component)label, constraints);
            return panel;
        }

        @Override
        Integer toObject(String str) {
            if (str.endsWith("%")) {
                return Integer.valueOf(str.substring(0, str.length() - 1).trim());
            }
            return Integer.valueOf(str.trim());
        }

        @Override
        Integer getValue() {
            return (Integer)((JSpinner)((JPanel)this.editor).getComponent(0)).getValue();
        }

        @Override
        void setValue(Integer value) {
            ((JSpinner)((JPanel)this.editor).getComponent(0)).setValue(value);
        }
    }

    static class BooleanParameterDescriptor
    extends ParameterDescriptor<Boolean, JCheckBox> {
        BooleanParameterDescriptor() {
        }

        @Override
        protected JCheckBox createEditor() {
            JCheckBox checkBox = new JCheckBox(" ");
            checkBox.addChangeListener(e -> this.notifyChangeListener());
            return checkBox;
        }

        @Override
        Boolean toObject(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        Boolean getValue() {
            return ((JCheckBox)this.editor).isSelected();
        }

        @Override
        void setValue(Boolean value) {
            ((JCheckBox)this.editor).setSelected(value);
        }
    }
}

