/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.pepsoft.util.swing.TiledImageViewer;

public class WPTileSelectionViewer
extends TiledImageViewer {
    private Point highlightedTileLocation;
    private Point selectedRectangleCorner1;
    private Point selectedRectangleCorner2;
    private final Set<Point> selectedTiles = new HashSet<Point>();
    private static final BufferedImage SCALE_BAR;
    private static final long serialVersionUID = 1L;

    public WPTileSelectionViewer() {
        this.setPaintGrid(true);
    }

    public WPTileSelectionViewer(boolean leftClickDrags, boolean paintCentre) {
        super(leftClickDrags, paintCentre);
        this.setPaintGrid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent((Graphics)g2);
        if (!this.selectedTiles.isEmpty()) {
            g2.setColor(Color.YELLOW);
            Composite previousComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            try {
                Rectangle clipBounds = g2.getClipBounds();
                for (Point selectedTile : this.selectedTiles) {
                    Rectangle tileBounds = this.getTileBounds(selectedTile.x, selectedTile.y);
                    if (!tileBounds.intersects(clipBounds)) continue;
                    g2.fillRect(tileBounds.x, tileBounds.y, tileBounds.width, tileBounds.height);
                }
            }
            finally {
                g2.setComposite(previousComposite);
            }
        }
        if (this.selectedRectangleCorner1 != null && this.selectedRectangleCorner2 != null) {
            g2.setColor(Color.CYAN);
            Rectangle rectangleBounds = this.getTileRectangleCoordinates(this.selectedRectangleCorner1, this.selectedRectangleCorner2);
            g2.drawRect(rectangleBounds.x, rectangleBounds.y, rectangleBounds.width - 1, rectangleBounds.height - 1);
        }
        if (this.highlightedTileLocation != null) {
            Rectangle rect = this.getTileBounds(this.highlightedTileLocation.x, this.highlightedTileLocation.y);
            g2.setColor(Color.RED);
            g2.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
        int zoom = this.getZoom();
        g2.drawImage((Image)SCALE_BAR, 10, this.getHeight() - 10 - SCALE_BAR.getHeight(), (ImageObserver)((Object)this));
        g2.setColor(Color.BLACK);
        String str = (zoom < 0 ? 100 << -zoom : 100 >> zoom) + " blocks";
        g2.drawString(str, 15 + SCALE_BAR.getWidth() + 1, this.getHeight() - 9);
        g2.setColor(Color.WHITE);
        g2.drawString(str, 15 + SCALE_BAR.getWidth(), this.getHeight() - 10);
        int middleX = this.getWidth() / 2;
        int middleY = this.getHeight() / 2;
        g2.setColor(Color.BLACK);
        str = this.getViewX() + ", " + this.getViewY();
        g2.drawString(str, middleX + 3, middleY - 1);
        g2.setColor(Color.WHITE);
        g2.drawString(str, middleX + 2, middleY - 2);
    }

    public Point getHighlightedTileLocation() {
        return this.highlightedTileLocation;
    }

    public void setHighlightedTileLocation(Point highlightedTileLocation) {
        if (this.highlightedTileLocation != null) {
            this.repaint(this.getTileBounds(this.highlightedTileLocation.x, this.highlightedTileLocation.y));
        }
        this.highlightedTileLocation = highlightedTileLocation;
        if (highlightedTileLocation != null) {
            this.repaint(this.getTileBounds(highlightedTileLocation.x, highlightedTileLocation.y));
        }
    }

    public void addSelectedTile(Point tileLocation) {
        if (!this.selectedTiles.contains(tileLocation)) {
            this.selectedTiles.add(tileLocation);
            this.repaint(this.getTileBounds(tileLocation.x, tileLocation.y));
        }
    }

    public boolean isSelectedTile(Point tileLocation) {
        return this.selectedTiles.contains(tileLocation);
    }

    public Set<Point> getSelectedTiles() {
        return Collections.unmodifiableSet(this.selectedTiles);
    }

    public void setSelectedTiles(Set<Point> selectedTiles) {
        this.selectedTiles.clear();
        this.selectedTiles.addAll(selectedTiles);
        this.repaint();
    }

    public void removeSelectedTile(Point tileLocation) {
        if (this.selectedTiles.contains(tileLocation)) {
            this.selectedTiles.remove(tileLocation);
            this.repaint(this.getTileBounds(tileLocation.x, tileLocation.y));
        }
    }

    public void clearSelectedTiles() {
        if (!this.selectedTiles.isEmpty()) {
            this.selectedTiles.clear();
            this.repaint();
        }
    }

    public Point getSelectedRectangleCorner1() {
        return this.selectedRectangleCorner1;
    }

    public void setSelectedRectangleCorner1(Point selectedRectangleCorner1) {
        if (this.selectedRectangleCorner1 != null && this.selectedRectangleCorner2 != null) {
            this.repaint(this.getTileRectangleCoordinates(this.selectedRectangleCorner1, this.selectedRectangleCorner2));
        }
        this.selectedRectangleCorner1 = selectedRectangleCorner1;
        if (selectedRectangleCorner1 != null && this.selectedRectangleCorner2 != null) {
            this.repaint(this.getTileRectangleCoordinates(selectedRectangleCorner1, this.selectedRectangleCorner2));
        }
    }

    public Point getSelectedRectangleCorner2() {
        return this.selectedRectangleCorner2;
    }

    public void setSelectedRectangleCorner2(Point selectedRectangleCorner2) {
        if (this.selectedRectangleCorner1 != null && this.selectedRectangleCorner2 != null) {
            this.repaint(this.getTileRectangleCoordinates(this.selectedRectangleCorner1, this.selectedRectangleCorner2));
        }
        this.selectedRectangleCorner2 = selectedRectangleCorner2;
        if (this.selectedRectangleCorner1 != null && selectedRectangleCorner2 != null) {
            this.repaint(this.getTileRectangleCoordinates(this.selectedRectangleCorner1, selectedRectangleCorner2));
        }
    }

    private Rectangle getTileRectangleCoordinates(Point tileCorner1, Point tileCorner2) {
        Rectangle corner1Coords = this.getTileBounds(tileCorner1.x, tileCorner1.y);
        Rectangle corner2Coords = this.getTileBounds(tileCorner2.x, tileCorner2.y);
        int left = Math.min(corner1Coords.x, corner2Coords.x);
        int right = Math.max(corner1Coords.x + corner1Coords.width - 1, corner2Coords.x + corner2Coords.width - 1);
        int top = Math.min(corner1Coords.y, corner2Coords.y);
        int bottom = Math.max(corner1Coords.y + corner1Coords.height - 1, corner2Coords.y + corner2Coords.height - 1);
        return new Rectangle(left, top, right - left + 1, bottom - top + 1);
    }

    static {
        try {
            SCALE_BAR = ImageIO.read(WPTileSelectionViewer.class.getResourceAsStream("/org/pepsoft/worldpainter/scale_bar.png"));
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error loading scale bar from classpath", e);
        }
    }
}

