/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.pepsoft.util.plugins.PluginManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.WPContext;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingTool {
    private static final Logger logger = LoggerFactory.getLogger(ScriptingTool.class);

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String extension;
        ScriptEngineManager scriptEngineManager;
        ScriptEngine scriptEngine;
        File scriptFile;
        LoggerContext logContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)logContext);
            logContext.reset();
            configurator.doConfigure(ClassLoader.getSystemResourceAsStream("logback-scriptingtool.xml"));
        }
        catch (JoranException configurator) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)logContext);
        System.err.println("WorldPainter scripting host version " + Version.VERSION + ".\nCopyright 2011-2025 pepsoft.org, The Netherlands.\nThis is free software distributed under the terms of the GPL, version 3, a copy\nof which you can find in the installation directory.\n");
        if (args.length < 1) {
            System.err.println("Usage:\n\n    wpscript <scriptfile> [<scriptarg> ...]\n\nWhere <scriptfile> is the filename, including extension, of the script to\nexecute, and [<scriptarg> ...] an optional list of one or more arguments for\nthe script, which will be available to the script in the arguments (from index\n0) or argv (from index 1) array.");
            System.exit(1);
        }
        if (!(scriptFile = new File(args[0])).isFile()) {
            System.err.println(args[0] + " does not exist or is not a regular file");
            System.exit(1);
        }
        String scriptFilePath = scriptFile.getCanonicalFile().getParent();
        String scriptFileName = scriptFile.getName();
        int p = scriptFileName.lastIndexOf(46);
        if (p == -1) {
            System.err.println("Script file name " + scriptFileName + " has no extension");
            System.exit(1);
        }
        if ((scriptEngine = (scriptEngineManager = new ScriptEngineManager()).getEngineByExtension(extension = scriptFileName.substring(p + 1))) == null) {
            System.err.println("Script file language " + extension + " not supported");
            System.exit(1);
        }
        scriptEngine.put("javax.script.filename", scriptFileName);
        try {
            Class.forName("org.pepsoft.worldpainter.DefaultPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Configuration config = Configuration.load();
        if (config == null) {
            logger.info("Creating new configuration");
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        X509Certificate trustedCert = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            trustedCert = (X509Certificate)certificateFactory.generateCertificate(ClassLoader.getSystemResourceAsStream("wproot.pem"));
        }
        catch (CertificateException e) {
            logger.error("Certificate exception while loading trusted root certificate", (Throwable)e);
        }
        if (trustedCert != null) {
            File pluginsDir = new File(Configuration.getConfigDir(), "plugins");
            if (pluginsDir.isDirectory()) {
                PluginManager.loadPlugins((File)pluginsDir, (PublicKey)trustedCert.getPublicKey(), (String)"org.pepsoft.worldpainter.plugins", (org.pepsoft.util.Version)Version.VERSION_OBJ, (boolean)false);
            }
        } else {
            logger.error("Trusted root certificate not available; not loading plugins");
        }
        WPPluginManager.initialise((UUID)config.getUuid(), (WPContext)WPContext.INSTANCE);
        if (args.length > 1) {
            System.err.print("Executing script \"" + scriptFileName + "\" with arguments ");
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    System.err.print(", ");
                }
                System.err.print("\"" + args[i] + "\"");
            }
            System.err.println("\n");
        } else {
            System.err.println("Executing script \"" + scriptFileName + "\" with no arguments.\n");
        }
        ArrayList<String> argList = new ArrayList<String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (String arg : args) {
            if (arg.startsWith("--") && arg.length() > 2 && arg.charAt(2) != '-') {
                p = arg.indexOf(61);
                if (p != -1) {
                    String key = arg.substring(2, p);
                    Layer.DataSize[] value = arg.substring(p + 1);
                    paramMap.put(key, value);
                    continue;
                }
                paramMap.put(arg.substring(2), "true");
                continue;
            }
            if (arg.startsWith("-") && arg.length() > 1 && arg.charAt(1) != '-') {
                try {
                    Integer.parseInt(arg);
                    argList.add(arg);
                    continue;
                }
                catch (NumberFormatException key) {
                    for (int i = 1; i < arg.length(); ++i) {
                        paramMap.put(arg.substring(i, i + 1), "true");
                    }
                    continue;
                }
            }
            argList.add(arg);
        }
        Bindings bindings = scriptEngine.getBindings(100);
        ScriptingContext context = new ScriptingContext(true);
        bindings.put("wp", (Object)context);
        String[] argArray = argList.toArray(new String[argList.size()]);
        bindings.put("argc", (Object)argArray.length);
        bindings.put("argv", (Object)argArray);
        String[] scriptArgs = new String[argArray.length - 1];
        System.arraycopy(argArray, 1, scriptArgs, 0, scriptArgs.length);
        bindings.put("arguments", (Object)scriptArgs);
        bindings.put("params", (Object)paramMap);
        HashMap<String, Layer.DataSize> dataSizes = new HashMap<String, Layer.DataSize>();
        for (Layer.DataSize dataSize : Layer.DataSize.values()) {
            dataSizes.put(dataSize.name(), dataSize);
        }
        bindings.put("DataSize", (Object)dataSizes);
        bindings.put("scriptDir", (Object)scriptFilePath);
        try {
            scriptEngine.eval(new FileReader(scriptFile));
            context.checkGoCalled(null);
        }
        catch (RuntimeException e) {
            logger.error(e.getClass().getSimpleName() + " occurred while executing " + scriptFileName, (Throwable)e);
            System.exit(2);
        }
        catch (ScriptException e) {
            logger.error("ScriptException occurred while executing " + scriptFileName, (Throwable)e);
            System.exit(2);
        }
    }
}

