/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.tools.RespawnPlayer;
import org.pepsoft.worldpainter.util.FileFilter;
import org.pepsoft.worldpainter.util.FileUtils;

public class RespawnPlayerDialog
extends JDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jTextField1;

    public RespawnPlayerDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RespawnPlayerDialog.this.setControlStates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RespawnPlayerDialog.this.setControlStates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RespawnPlayerDialog.this.setControlStates();
            }
        });
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RespawnPlayerDialog.this.dispose();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.setLocationRelativeTo(parent);
    }

    private void selectFile() {
        Configuration config = Configuration.getInstance();
        File mySavesDir = config != null && config.getSavesDirectory() != null ? config.getSavesDirectory() : DesktopUtils.getDocumentsFolder();
        File levelDatFile = FileUtils.selectFileForOpen(this, "Select Minecraft map level.dat file", mySavesDir, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().equalsIgnoreCase("level.dat");
            }

            @Override
            public String getDescription() {
                return "Minecraft level.dat files";
            }

            @Override
            public String getExtensions() {
                return "level.dat";
            }
        });
        if (levelDatFile != null) {
            this.jTextField1.setText(levelDatFile.getAbsolutePath());
        }
    }

    private void respawn() {
        try {
            File file = new File(this.jTextField1.getText());
            RespawnPlayer.respawnPlayer((File)file);
            Configuration config = Configuration.getInstance();
            if (config != null) {
                config.setSavesDirectory(file.getParentFile().getParentFile());
            }
            JOptionPane.showMessageDialog(this, "Player respawned");
            this.dispose();
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading or writing level.dat", e);
        }
    }

    private void setControlStates() {
        File file = new File(this.jTextField1.getText());
        this.jButton2.setEnabled(file.isFile() && file.getName().equalsIgnoreCase("level.dat"));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Respawn Player");
        this.jLabel1.setText("Use this tool to respawn the player in a single player");
        this.jLabel2.setText("world where respawn after death is broken.");
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setText("Make sure Minecraft is not running!");
        this.jLabel4.setText("Then, select the level.dat file of the world, and press");
        this.jLabel5.setText("the button to respawn the player:");
        this.jButton1.setText("...");
        this.jButton1.addActionListener(this::jButton1ActionPerformed);
        this.jButton2.setText("Respawn");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(this::jButton2ActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTextField1, -1, 346, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton1)).addGap(18, 18, 18).addComponent(this.jButton2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.respawn();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.selectFile();
    }
}

