/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.IOException;
import java.util.TreeSet;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;

public class LargeOceanFinder {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        config = Configuration.load();
        if (config == null) {
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        biomeScheme = BiomeSchemeManager.getSharedBiomeScheme((int)10);
        if (biomeScheme == null) {
            System.err.println("Can't continue without a Minecraft 1.7 - 1.10 minecraft.jar");
            System.exit(1);
        }
        seed = 0L;
        biomes = new int[16384];
        largeOceanWorlds = new TreeSet<World>();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                largeOceanWorlds.forEach(System.out::println);
            }
        });
        block0: while (true) {
            biomeScheme.setSeed(seed);
            oceanTilesFound = new int[]{0};
            oceanOrMushroomTilesFound = LargeOceanFinder.visitTilesInSpiral(new TileVisitor(){
                private boolean mushroomTileFound;

                @Override
                public boolean visitBlock(int x, int z) {
                    biomeScheme.getBiomes(x * 128, z * 128, 128, 128, biomes);
                    boolean mushroomTile = false;
                    for (int biome : biomes) {
                        if (biome == 15 || biome == 14) {
                            mushroomTile = true;
                            continue;
                        }
                        if (biome == 0 || biome == 24) continue;
                        return false;
                    }
                    if (mushroomTile) {
                        this.mushroomTileFound = true;
                    } else if (!this.mushroomTileFound) {
                        oceanTilesFound[0] = oceanTilesFound[0] + 1;
                    }
                    return true;
                }
            });
            if (largeOceanWorlds.isEmpty() || oceanOrMushroomTilesFound > ((World)largeOceanWorlds.first()).oceanOrMushroomTiles) {
                if (largeOceanWorlds.size() > 100) {
                    largeOceanWorlds.remove(largeOceanWorlds.first());
                }
                largeOceanWorlds.add(new World(seed, oceanTilesFound[0], oceanOrMushroomTilesFound));
            }
            if (++seed % 10000L != 0L) continue;
            System.out.println("Results after " + seed + " seeds:");
            var9_8 = largeOceanWorlds.iterator();
            while (true) {
                if (var9_8.hasNext()) ** break;
                continue block0;
                world = (World)var9_8.next();
                System.out.println("    " + world);
            }
            break;
        }
    }

    private static int visitTilesInSpiral(TileVisitor tileVisitor) {
        int count = 0;
        if (tileVisitor.visitBlock(0, 0)) {
            ++count;
            int r = 1;
            block0: while (true) {
                int z;
                int x;
                for (x = r; x > -r; --x) {
                    if (!tileVisitor.visitBlock(x, r)) break block0;
                    ++count;
                }
                for (z = r; z > -r; --z) {
                    if (!tileVisitor.visitBlock(-r, z)) break block0;
                    ++count;
                }
                for (x = -r; x < r; ++x) {
                    if (!tileVisitor.visitBlock(x, -r)) break block0;
                    ++count;
                }
                for (z = -r; z < r; ++z) {
                    if (!tileVisitor.visitBlock(r, z)) break block0;
                    ++count;
                }
                ++r;
            }
        }
        return count;
    }

    static interface TileVisitor {
        public boolean visitBlock(int var1, int var2);
    }

    static class World
    implements Comparable<World> {
        final long seed;
        final int oceanTiles;
        final int oceanOrMushroomTiles;

        World(long seed, int oceanTiles, int oceanOrMushroomTiles) {
            this.seed = seed;
            this.oceanTiles = oceanTiles;
            this.oceanOrMushroomTiles = oceanOrMushroomTiles;
        }

        @Override
        public int compareTo(World o) {
            if (this.oceanOrMushroomTiles > o.oceanOrMushroomTiles) {
                return 1;
            }
            if (this.oceanOrMushroomTiles < o.oceanOrMushroomTiles) {
                return -1;
            }
            if (this.oceanTiles > o.oceanTiles) {
                return 1;
            }
            if (this.oceanTiles < o.oceanTiles) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "Seed: " + this.seed + ", ocean tiles: " + this.oceanTiles + " , ocean or mushroom island tiles: " + this.oceanOrMushroomTiles;
        }
    }
}

