/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.TreeSet;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;

public class LargeContinentFinder {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        config = Configuration.load();
        if (config == null) {
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        biomeScheme = BiomeSchemeManager.getSharedBiomeScheme((int)10);
        if (biomeScheme == null) {
            System.err.println("Can't continue without a Minecraft 1.7 - 1.10 minecraft.jar");
            System.exit(1);
        }
        seed = 0L;
        biomes = new int[16384];
        largeContinentWorlds = new TreeSet<World>();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                largeContinentWorlds.forEach(System.out::println);
            }
        });
        block0: while (true) {
            biomeScheme.setSeed(seed);
            continentTilesFound = LargeContinentFinder.visitTilesInSpiral((TileVisitor)LambdaMetafactory.metafactory(null, null, null, (II)Z, lambda$main$0(org.pepsoft.worldpainter.BiomeScheme int[] int int ), (II)Z)((BiomeScheme)biomeScheme, (int[])biomes));
            if (largeContinentWorlds.isEmpty() || continentTilesFound > ((World)largeContinentWorlds.first()).continentTiles) {
                if (largeContinentWorlds.size() > 100) {
                    largeContinentWorlds.remove(largeContinentWorlds.first());
                }
                largeContinentWorlds.add(new World(seed, continentTilesFound));
            }
            if (++seed % 100L != 0L) continue;
            System.out.println("Results after " + seed + " seeds:");
            var8_7 = largeContinentWorlds.iterator();
            while (true) {
                if (var8_7.hasNext()) ** break;
                continue block0;
                world = (World)var8_7.next();
                System.out.println("    " + world);
            }
            break;
        }
    }

    private static int visitTilesInSpiral(TileVisitor tileVisitor) {
        int count = 0;
        if (tileVisitor.visitBlock(0, 0)) {
            ++count;
            int r = 1;
            block0: while (true) {
                int z;
                int x;
                for (x = r; x > -r; --x) {
                    if (!tileVisitor.visitBlock(x, r)) break block0;
                    ++count;
                }
                for (z = r; z > -r; --z) {
                    if (!tileVisitor.visitBlock(-r, z)) break block0;
                    ++count;
                }
                for (x = -r; x < r; ++x) {
                    if (!tileVisitor.visitBlock(x, -r)) break block0;
                    ++count;
                }
                for (z = -r; z < r; ++z) {
                    if (!tileVisitor.visitBlock(r, z)) break block0;
                    ++count;
                }
                ++r;
            }
        }
        return count;
    }

    private static /* synthetic */ boolean lambda$main$0(BiomeScheme biomeScheme, int[] biomes, int x, int z) {
        biomeScheme.getBiomes(x * 128, z * 128, 128, 128, biomes);
        for (int biome : biomes) {
            if (biome != 0 && biome != 24) continue;
            return false;
        }
        return true;
    }

    static interface TileVisitor {
        public boolean visitBlock(int var1, int var2);
    }

    static class World
    implements Comparable<World> {
        final long seed;
        final int continentTiles;

        World(long seed, int continentTiles) {
            this.seed = seed;
            this.continentTiles = continentTiles;
        }

        @Override
        public int compareTo(World o) {
            if (this.continentTiles > o.continentTiles) {
                return 1;
            }
            if (this.continentTiles < o.continentTiles) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "Seed: " + this.seed + ", continent tiles: " + this.continentTiles;
        }
    }
}

