/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.swing.BetterJPopupMenu;
import org.pepsoft.util.swing.TiledImageViewer;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MouseAdapter;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileFactory;
import org.pepsoft.worldpainter.TileFactoryFactory;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.WPTileProvider;
import org.pepsoft.worldpainter.heightMaps.BandedHeightMap;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.heightMaps.ConstantHeightMap;
import org.pepsoft.worldpainter.heightMaps.DelegatingHeightMap;
import org.pepsoft.worldpainter.heightMaps.DisplacementHeightMap;
import org.pepsoft.worldpainter.heightMaps.MandelbrotHeightMap;
import org.pepsoft.worldpainter.heightMaps.MaximisingHeightMap;
import org.pepsoft.worldpainter.heightMaps.NinePatchHeightMap;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.heightMaps.ProductHeightMap;
import org.pepsoft.worldpainter.heightMaps.ShelvingHeightMap;
import org.pepsoft.worldpainter.heightMaps.SlopeHeightMap;
import org.pepsoft.worldpainter.heightMaps.SumHeightMap;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;
import org.pepsoft.worldpainter.heightMaps.gui.HeightMapPropertiesPanel;
import org.pepsoft.worldpainter.heightMaps.gui.HeightMapTileProvider;
import org.pepsoft.worldpainter.heightMaps.gui.HeightMapTreeCellRenderer;
import org.pepsoft.worldpainter.heightMaps.gui.HeightMapTreeModel;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.Theme;
import org.pepsoft.worldpainter.themes.impl.simple.SimpleThemeEditor;
import org.pepsoft.worldpainter.util.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeightMapEditor
extends JFrame
implements HeightMapPropertiesPanel.HeightMapListener {
    private HeightMap rootHeightMap;
    private HeightMap focusHeightMap;
    private final Map<Point, Tile> tileCache = Collections.synchronizedMap(new HashMap());
    private HeightMapTreeModel treeModel;
    private ViewMode viewMode = ViewMode.HEIGHT_MAP;
    private SimpleTheme theme = SimpleTheme.createDefault((Terrain)Terrain.GRASS, (int)0, (int)256, (int)62);
    private long seed = new Random().nextLong();
    private HeightMapTreeCellRenderer cellRenderer;
    private static final Tile RENDERING = new Tile(0, 0, 0, 0, false){};
    private static final Logger logger = LoggerFactory.getLogger(HeightMapEditor.class);
    private ButtonGroup buttonGroup1;
    private JCheckBox checkBoxShowGrid;
    private HeightMapPropertiesPanel heightMapPropertiesPanel1;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JToolBar jToolBar1;
    private JTree jTree1;
    private JRadioButton radioButtonViewAsHeightMap;
    private JRadioButton radioButtonViewAsTerrain;
    private SimpleThemeEditor simpleThemeEditor1;
    private TiledImageViewer tiledImageViewer1;

    public HeightMapEditor(HeightMap heightMap) throws IOException {
        this.rootHeightMap = heightMap;
        this.initComponents();
        this.tiledImageViewer1.addMouseWheelListener(new MouseWheelListener(){
            private int zoom = 0;

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int oldZoom = this.zoom;
                this.zoom = e.getWheelRotation() < 0 ? Math.min(this.zoom - e.getWheelRotation(), 6) : Math.max(this.zoom - e.getWheelRotation(), -4);
                if (this.zoom != oldZoom) {
                    HeightMapEditor.this.tiledImageViewer1.setZoom(this.zoom, e.getX(), e.getY());
                }
            }
        });
        this.cellRenderer = new HeightMapTreeCellRenderer();
        this.jTree1.setCellRenderer(this.cellRenderer);
        ToolTipManager.sharedInstance().registerComponent(this.jTree1);
        this.heightMapPropertiesPanel1.setListener(this);
        this.simpleThemeEditor1.setTheme(this.theme);
        this.simpleThemeEditor1.setChangeListener(editor -> this.themeChanged());
        this.createHeightMap();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                HeightMapEditor.this.jSplitPane3.setDividerLocation(1.0);
            }
        });
        GUIUtils.scaleToUI((Container)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heightMapChanged(HeightMap heightMap, String propertyName) {
        if (!propertyName.equals("name")) {
            Map<Point, Tile> map = this.tileCache;
            synchronized (map) {
                this.tileCache.clear();
                this.tileCache.notifyAll();
            }
            this.tiledImageViewer1.refresh(true);
        }
    }

    private void themeChanged() {
        this.simpleThemeEditor1.save();
        if (this.radioButtonViewAsTerrain.isSelected()) {
            this.installHeightMap(false);
        }
    }

    private void createHeightMap() {
        this.focusOn(this.rootHeightMap);
        this.installHeightMap(true);
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }

            private void showPopupMenu(MouseEvent event) {
                TreePath path = HeightMapEditor.this.jTree1.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return;
                }
                HeightMapEditor.this.jTree1.setSelectionPath(path);
                HeightMap heightMap = (HeightMap)path.getLastPathComponent();
                TreePath parentPath = path.getParentPath();
                DelegatingHeightMap parent = parentPath != null ? (DelegatingHeightMap)parentPath.getLastPathComponent() : null;
                BetterJPopupMenu menu = new BetterJPopupMenu();
                JMenuItem menuItem = new JMenuItem("Focus Here");
                menuItem.addActionListener(actionEvent -> {
                    HeightMapEditor.this.focusOn(heightMap);
                    HeightMapEditor.this.installHeightMap(false);
                });
                menu.add(menuItem);
                JMenu insertMenu = new JMenu("Insert");
                menuItem = new JMenuItem("Product");
                menuItem.addActionListener(actionEvent -> {
                    ProductHeightMap productHeightMap = new ProductHeightMap(heightMap, (HeightMap)new ConstantHeightMap(1.0));
                    this.replace(parent, heightMap, (HeightMap)productHeightMap);
                });
                insertMenu.add(menuItem);
                menuItem = new JMenuItem("Sum");
                menuItem.addActionListener(actionEvent -> {
                    SumHeightMap sumHeightMap = new SumHeightMap(heightMap, (HeightMap)new ConstantHeightMap(0.0));
                    this.replace(parent, heightMap, (HeightMap)sumHeightMap);
                });
                insertMenu.add(menuItem);
                menuItem = new JMenuItem("Maximum");
                menuItem.addActionListener(actionEvent -> {
                    MaximisingHeightMap maximisingHeightMap = new MaximisingHeightMap(heightMap, (HeightMap)new ConstantHeightMap(0.0));
                    this.replace(parent, heightMap, (HeightMap)maximisingHeightMap);
                });
                insertMenu.add(menuItem);
                menuItem = new JMenuItem("Slope");
                menuItem.addActionListener(actionEvent -> {
                    SlopeHeightMap slopeHeightMap = new SlopeHeightMap(heightMap);
                    this.replace(parent, heightMap, (HeightMap)slopeHeightMap);
                });
                insertMenu.add(menuItem);
                menuItem = new JMenuItem("Displacement");
                menuItem.addActionListener(actionEvent -> {
                    DisplacementHeightMap displacementHeightMap = new DisplacementHeightMap(heightMap, (HeightMap)new ConstantHeightMap(0.0), (HeightMap)new ConstantHeightMap(0.0));
                    this.replace(parent, heightMap, (HeightMap)displacementHeightMap);
                });
                insertMenu.add(menuItem);
                menuItem = new JMenuItem("Transformation");
                menuItem.addActionListener(actionEvent -> {
                    TransformingHeightMap transformingHeightMap = new TransformingHeightMap(heightMap.getName(), heightMap, 1.0f, 1.0f, 0, 0, 0.0f);
                    this.replace(parent, heightMap, (HeightMap)transformingHeightMap);
                });
                insertMenu.add(menuItem);
                menuItem = new JMenuItem("Shelves");
                menuItem.addActionListener(actionEvent -> {
                    ShelvingHeightMap shelvingHeightMap = new ShelvingHeightMap(heightMap);
                    this.replace(parent, heightMap, (HeightMap)shelvingHeightMap);
                });
                insertMenu.add(menuItem);
                menu.add(insertMenu);
                JMenu replaceMenu = new JMenu("Replace");
                menuItem = new JMenuItem("Mandelbrot");
                menuItem.addActionListener(actionEvent -> {
                    MandelbrotHeightMap mandelbrotHeightMap = new MandelbrotHeightMap();
                    this.replace(parent, heightMap, (HeightMap)mandelbrotHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Nine Patch");
                menuItem.addActionListener(actionEvent -> {
                    NinePatchHeightMap ninePatchHeightMap = new NinePatchHeightMap(100, 25, 1.0);
                    this.replace(parent, heightMap, (HeightMap)ninePatchHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Constant");
                menuItem.addActionListener(actionEvent -> {
                    ConstantHeightMap constantHeightMap = new ConstantHeightMap(1.0);
                    this.replace(parent, heightMap, (HeightMap)constantHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Bitmap");
                menuItem.addActionListener(actionEvent -> {
                    File myHeightMapDir = Configuration.getInstance().getHeightMapsDirectory();
                    File file = ImageUtils.selectImageForOpen(HeightMapEditor.this, "a height map image file", myHeightMapDir);
                    if (file != null) {
                        try {
                            BufferedImage image = ImageIO.read(file);
                            BitmapHeightMap bitmapHeightMap = BitmapHeightMap.build().withName(file.getName()).withImage(image).withFile(file).now();
                            this.replace(parent, heightMap, (HeightMap)bitmapHeightMap);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Noise");
                menuItem.addActionListener(actionEvent -> {
                    NoiseHeightMap noiseHeightMap = new NoiseHeightMap(1.0, 1.0, 1);
                    this.replace(parent, heightMap, (HeightMap)noiseHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Bands");
                menuItem.addActionListener(actionEvent -> {
                    BandedHeightMap bandedHeightMap = new BandedHeightMap(100, 1.0, 100, 1.0, false);
                    this.replace(parent, heightMap, (HeightMap)bandedHeightMap);
                });
                replaceMenu.add(menuItem);
                replaceMenu.addSeparator();
                menuItem = new JMenuItem("Product");
                menuItem.addActionListener(actionEvent -> {
                    ProductHeightMap productHeightMap = new ProductHeightMap((HeightMap)new ConstantHeightMap(1.0), (HeightMap)new ConstantHeightMap(1.0));
                    this.replace(parent, heightMap, (HeightMap)productHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Sum");
                menuItem.addActionListener(actionEvent -> {
                    SumHeightMap sumHeightMap = new SumHeightMap((HeightMap)new ConstantHeightMap(0.5), (HeightMap)new ConstantHeightMap(0.5));
                    this.replace(parent, heightMap, (HeightMap)sumHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Maximum");
                menuItem.addActionListener(actionEvent -> {
                    MaximisingHeightMap maximisingHeightMap = new MaximisingHeightMap((HeightMap)new ConstantHeightMap(1.0), (HeightMap)new ConstantHeightMap(1.0));
                    this.replace(parent, heightMap, (HeightMap)maximisingHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Slope");
                menuItem.addActionListener(actionEvent -> {
                    SlopeHeightMap slopeHeightMap = new SlopeHeightMap((HeightMap)new ConstantHeightMap(1.0));
                    this.replace(parent, heightMap, (HeightMap)slopeHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Displacement");
                menuItem.addActionListener(actionEvent -> {
                    DisplacementHeightMap displacementHeightMap = new DisplacementHeightMap((HeightMap)new ConstantHeightMap(1.0), (HeightMap)new ConstantHeightMap(0.0), (HeightMap)new ConstantHeightMap(0.0));
                    this.replace(parent, heightMap, (HeightMap)displacementHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Transformation");
                menuItem.addActionListener(actionEvent -> {
                    TransformingHeightMap transformingHeightMap = new TransformingHeightMap(null, (HeightMap)new ConstantHeightMap(1.0), 1.0f, 1.0f, 0, 0, 0.0f);
                    this.replace(parent, heightMap, (HeightMap)transformingHeightMap);
                });
                replaceMenu.add(menuItem);
                menuItem = new JMenuItem("Shelves");
                menuItem.addActionListener(actionEvent -> {
                    ShelvingHeightMap shelvingHeightMap = new ShelvingHeightMap((HeightMap)new ConstantHeightMap(1.0));
                    this.replace(parent, heightMap, (HeightMap)shelvingHeightMap);
                });
                replaceMenu.add(menuItem);
                menu.add(replaceMenu);
                if (heightMap instanceof DelegatingHeightMap) {
                    menuItem = new JMenuItem("Delete");
                    menuItem.addActionListener(e -> {
                        this.replace(parent, heightMap, ((DelegatingHeightMap)heightMap).getHeightMap(0));
                        HeightMapEditor.this.treeModel.notifyListeners();
                    });
                    menu.add(menuItem);
                }
                menu.show(HeightMapEditor.this.jTree1, event.getX(), event.getY());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void replace(DelegatingHeightMap parent, HeightMap oldHeightMap, HeightMap newHeightMap) {
                if (parent == null) {
                    HeightMapEditor.this.rootHeightMap = newHeightMap;
                    HeightMapEditor.this.focusOn(newHeightMap);
                    HeightMapEditor.this.installHeightMap(true);
                } else {
                    parent.replace(oldHeightMap, newHeightMap);
                    if (oldHeightMap == HeightMapEditor.this.focusHeightMap) {
                        HeightMapEditor.this.focusOn(newHeightMap);
                    }
                    HeightMapEditor.this.treeModel.notifyListeners();
                    Map<Point, Tile> map = HeightMapEditor.this.tileCache;
                    synchronized (map) {
                        HeightMapEditor.this.tileCache.clear();
                        HeightMapEditor.this.tileCache.notifyAll();
                    }
                    HeightMapEditor.this.tiledImageViewer1.refresh(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installHeightMap(boolean updateTreeModel) {
        switch (this.viewMode) {
            case HEIGHT_MAP: {
                this.tiledImageViewer1.setTileProvider((org.pepsoft.util.swing.TileProvider)new HeightMapTileProvider(this.focusHeightMap));
                this.tiledImageViewer1.setGridColour(Color.GRAY);
                break;
            }
            case TERRAIN: {
                HeightMapTileFactory tileFactory = new HeightMapTileFactory(this.seed, this.focusHeightMap, 0, 256, false, (Theme)this.theme);
                Map<Point, Tile> map = this.tileCache;
                synchronized (map) {
                    this.tileCache.clear();
                }
                TileProvider tileProvider = new TileProvider(){
                    final /* synthetic */ TileFactory val$tileFactory;
                    {
                        this.val$tileFactory = tileFactory;
                    }

                    public Rectangle getExtent() {
                        return null;
                    }

                    public boolean isTilePresent(int x, int y) {
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Tile getTile(int x, int y) {
                        Tile tile;
                        Point coords = new Point(x, y);
                        Map<Point, Tile> map = HeightMapEditor.this.tileCache;
                        synchronized (map) {
                            tile = HeightMapEditor.this.tileCache.get(coords);
                            if (tile == RENDERING) {
                                do {
                                    try {
                                        HeightMapEditor.this.tileCache.wait();
                                        tile = HeightMapEditor.this.tileCache.get(coords);
                                    }
                                    catch (InterruptedException e) {
                                        throw new RuntimeException("Thread interrupted while waiting for tile to be rendered");
                                    }
                                } while (HeightMapEditor.this.tileCache.get(coords) == RENDERING);
                            }
                            if (tile == null) {
                                HeightMapEditor.this.tileCache.put(coords, RENDERING);
                            }
                        }
                        if (tile == null) {
                            tile = this.val$tileFactory.createTile(x, y);
                            map = HeightMapEditor.this.tileCache;
                            synchronized (map) {
                                HeightMapEditor.this.tileCache.put(coords, tile);
                                HeightMapEditor.this.tileCache.notifyAll();
                            }
                        }
                        return tile;
                    }
                };
                this.tiledImageViewer1.setTileProvider((org.pepsoft.util.swing.TileProvider)new WPTileProvider(tileProvider, ColourScheme.DEFAULT, null, Collections.singleton(Biome.INSTANCE), false, 10, TileRenderer.LightOrigin.NORTHWEST, null));
                this.tiledImageViewer1.setGridColour(Color.BLACK);
            }
        }
        if (updateTreeModel) {
            this.treeModel = new HeightMapTreeModel(this.rootHeightMap);
            this.jTree1.setModel(this.treeModel);
        }
    }

    private void focusOn(HeightMap heightMap) {
        this.focusHeightMap = heightMap;
        this.cellRenderer.setFocusHeightMap(this.focusHeightMap);
        this.jTree1.repaint();
    }

    private void switchView() {
        switch (this.viewMode) {
            case TERRAIN: {
                if (!this.radioButtonViewAsHeightMap.isSelected()) break;
                this.viewMode = ViewMode.HEIGHT_MAP;
                this.installHeightMap(false);
                break;
            }
            case HEIGHT_MAP: {
                if (!this.radioButtonViewAsTerrain.isSelected()) break;
                this.viewMode = ViewMode.TERRAIN;
                this.installHeightMap(false);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.radioButtonViewAsHeightMap = new JRadioButton();
        this.radioButtonViewAsTerrain = new JRadioButton();
        this.checkBoxShowGrid = new JCheckBox();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.heightMapPropertiesPanel1 = new HeightMapPropertiesPanel();
        this.jSplitPane3 = new JSplitPane();
        this.tiledImageViewer1 = new TiledImageViewer();
        this.simpleThemeEditor1 = new SimpleThemeEditor();
        this.setDefaultCloseOperation(2);
        this.setTitle("Height Map Editor");
        this.jToolBar1.setRollover(true);
        this.jButton1.setText("New Seed");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeightMapEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jLabel1.setText("View as:");
        this.jToolBar1.add(this.jLabel1);
        this.buttonGroup1.add(this.radioButtonViewAsHeightMap);
        this.radioButtonViewAsHeightMap.setSelected(true);
        this.radioButtonViewAsHeightMap.setText("height map");
        this.radioButtonViewAsHeightMap.setFocusable(false);
        this.radioButtonViewAsHeightMap.setVerticalTextPosition(3);
        this.radioButtonViewAsHeightMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeightMapEditor.this.radioButtonViewAsHeightMapActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.radioButtonViewAsHeightMap);
        this.buttonGroup1.add(this.radioButtonViewAsTerrain);
        this.radioButtonViewAsTerrain.setText("terrain");
        this.radioButtonViewAsTerrain.setFocusable(false);
        this.radioButtonViewAsTerrain.setVerticalTextPosition(3);
        this.radioButtonViewAsTerrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeightMapEditor.this.radioButtonViewAsTerrainActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.radioButtonViewAsTerrain);
        this.checkBoxShowGrid.setSelected(true);
        this.checkBoxShowGrid.setText("Show grid:");
        this.checkBoxShowGrid.setFocusable(false);
        this.checkBoxShowGrid.setVerticalTextPosition(3);
        this.checkBoxShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HeightMapEditor.this.checkBoxShowGridActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.checkBoxShowGrid);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.1);
        this.jSplitPane2.setContinuousLayout(true);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                HeightMapEditor.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane2.setTopComponent(this.jScrollPane1);
        this.jSplitPane2.setBottomComponent(this.heightMapPropertiesPanel1);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jSplitPane3.setOrientation(0);
        this.jSplitPane3.setResizeWeight(0.9);
        this.jSplitPane3.setContinuousLayout(true);
        this.jSplitPane3.setOneTouchExpandable(true);
        this.tiledImageViewer1.setPaintGrid(true);
        this.jSplitPane3.setTopComponent((Component)this.tiledImageViewer1);
        this.jSplitPane3.setBottomComponent(this.simpleThemeEditor1);
        this.jSplitPane1.setRightComponent(this.jSplitPane3);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(null);
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        if (this.jTree1.getSelectionCount() == 1) {
            HeightMap heightMap = (HeightMap)this.jTree1.getSelectionPath().getLastPathComponent();
            this.heightMapPropertiesPanel1.setHeightMap(heightMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton1ActionPerformed(ActionEvent evt) {
        this.seed = new Random().nextLong();
        this.rootHeightMap.setSeed(this.seed);
        this.theme.setSeed(this.seed);
        Map<Point, Tile> map = this.tileCache;
        synchronized (map) {
            this.tileCache.clear();
            this.tileCache.notifyAll();
        }
        this.tiledImageViewer1.refresh(true);
    }

    private void radioButtonViewAsHeightMapActionPerformed(ActionEvent evt) {
        this.switchView();
    }

    private void radioButtonViewAsTerrainActionPerformed(ActionEvent evt) {
        this.switchView();
    }

    private void checkBoxShowGridActionPerformed(ActionEvent evt) {
        this.tiledImageViewer1.setPaintGrid(this.checkBoxShowGrid.isSelected());
    }

    public static void main(String[] args) {
        Configuration config = null;
        try {
            config = Configuration.load();
        }
        catch (IOException | ClassNotFoundException | Error | RuntimeException e) {
            HeightMapEditor.configError(e);
        }
        if (config == null) {
            if (!logger.isDebugEnabled()) {
                logger.info("Creating new configuration");
            }
            config = new Configuration();
        }
        Configuration.setInstance((Configuration)config);
        logger.info("Installation ID: " + config.getUuid());
        HeightMap rootHeightMap = TileFactoryFactory.createFancyTileFactory((long)new Random().nextLong(), (Terrain)Terrain.GRASS, (int)0, (int)256, (int)62, (int)58, (boolean)false, (float)20.0f, (double)1.0).getHeightMap();
        EventQueue.invokeLater(() -> {
            try {
                HeightMapEditor heightMapEditor = new HeightMapEditor(rootHeightMap);
                heightMapEditor.setDefaultCloseOperation(3);
                heightMapEditor.setVisible(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static void configError(Throwable e) {
        logger.error("Exception while loading config file", e);
        JOptionPane.showMessageDialog(null, "Could not read configuration file! Resetting configuration.\n\nException type: " + e.getClass().getSimpleName() + "\nMessage: " + e.getMessage(), "Configuration Error", 0);
    }

    static enum ViewMode {
        HEIGHT_MAP,
        TERRAIN;

    }
}

