/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.UnloadableWorldException;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldIO;
import org.pepsoft.worldpainter.layers.Layer;

public class DumpWorld {
    private static final String[] GAME_TYPES = new String[]{"SURVIVAL", "CREATIVE", "ADVENTURE", "HARDCORE"};
    private static final String[] DIFFICULTIES = new String[]{"PEACEFUL", "EASY", "NORMAL", "HARD"};

    public static void main(String[] args) throws IOException, UnloadableWorldException {
        WorldIO worldIO = new WorldIO();
        worldIO.load((InputStream)new FileInputStream(args[0]));
        World2 world = worldIO.getWorld();
        System.out.println("Name: " + world.getName());
        if (world.getMetadata() != null) {
            world.getMetadata().entrySet().forEach(entry -> System.out.println("   " + (String)entry.getKey() + ": " + entry.getValue()));
        }
        System.out.println("History:");
        world.getHistory().forEach(entry -> System.out.println("    " + entry.getText()));
        if (world.getPlatform() != null) {
            System.out.printf("Last exported for platform: %s%n", world.getPlatform().displayName);
        }
        System.out.println("Game type: " + world.getGameType());
        System.out.println("Difficulty: " + DIFFICULTIES[world.getDifficulty()]);
        if (world.getImportedFrom() != null) {
            System.out.println("Imported from: " + world.getImportedFrom());
        }
        System.out.println("Max height: " + world.getMaxHeight());
        System.out.println("Spawn point: " + world.getSpawnPoint().y + "," + world.getSpawnPoint().y);
        System.out.println("Up is: " + world.getUpIs());
        boolean headerPrinted = false;
        for (int i = 0; i < 96; ++i) {
            MixedMaterial customTerrain = world.getMixedMaterial(i);
            if (customTerrain == null) continue;
            if (!headerPrinted) {
                System.out.println("Custom terrains installed:");
                headerPrinted = true;
            }
            System.out.println("    Custom " + (i + 1));
            System.out.println("        Name: " + customTerrain.getName());
            System.out.println("        Mode: " + customTerrain.getMode());
            Arrays.stream(customTerrain.getRows()).forEach(row -> System.out.println("        Material: " + row));
        }
        if (!headerPrinted) {
            System.out.println("No custom terrains installed");
        }
        for (Dimension dimension : world.getDimensions()) {
            DumpWorld.dumpDimension(dimension);
        }
    }

    private static void dumpDimension(Dimension dimension) {
        System.out.println("Dimension: " + dimension.getName() + " (index: " + dimension.getAnchor().dim + ")");
        System.out.println("    Size: " + dimension.getWidth() + "x" + dimension.getHeight() + " tiles");
        System.out.println("    Westernmost tile: " + dimension.getLowestX() + "; easternmost tile: " + dimension.getHighestX());
        System.out.println("    Northernmost tile: " + dimension.getLowestY() + "; southernmost tile: " + dimension.getHighestY());
        System.out.println("    Total number of tiles: " + dimension.getTileCount());
        System.out.println("    Generator: " + dimension.getGenerator());
        System.out.println("    WorldPainter seed: " + dimension.getSeed() + "; Minecraft seed: " + dimension.getMinecraftSeed());
        if (dimension.getBorder() != null) {
            if (dimension.getBorder().isEndless()) {
                switch (dimension.getBorder()) {
                    case ENDLESS_LAVA: 
                    case ENDLESS_WATER: {
                        System.out.println("    Border: " + dimension.getBorder() + " (level; " + dimension.getBorderLevel() + ")");
                        break;
                    }
                    default: {
                        System.out.println("    Border: " + dimension.getBorder());
                        break;
                    }
                }
            } else {
                switch (dimension.getBorder()) {
                    case LAVA: 
                    case WATER: {
                        System.out.println("    Border: " + dimension.getBorder() + " (size: " + dimension.getBorderSize() + "; level; " + dimension.getBorderLevel() + ")");
                        break;
                    }
                    default: {
                        System.out.println("    Border: " + dimension.getBorder() + " (size: " + dimension.getBorderSize() + ")");
                        break;
                    }
                }
            }
        } else {
            System.out.println("    Border: none");
        }
        if (dimension.getAnchor().invert) {
            System.out.println("    Ceiling height: " + dimension.getCeilingHeight());
        }
        System.out.println("    Max height: " + dimension.getMaxHeight());
        System.out.println("    Contour separation: " + dimension.getContourSeparation());
        System.out.println("    Grid size: " + dimension.getGridSize());
        System.out.println("    Last view position: " + dimension.getLastViewPosition().x + "," + dimension.getLastViewPosition().y);
        for (Overlay overlay : dimension.getOverlays()) {
            System.out.println("    Overlay image: " + overlay.getFile());
            System.out.println("        Enabled: " + overlay.isEnabled());
            System.out.println("        Offset: " + overlay.getOffsetX() + "," + overlay.getOffsetY());
            System.out.println("        Scale:" + overlay.getScale());
            System.out.println("        Transparency: " + overlay.getTransparency());
        }
        System.out.println("    Subfurface material: " + dimension.getSubsurfaceMaterial());
        System.out.println("    Top layer depth: " + dimension.getTopLayerMinDepth() + " - " + (dimension.getTopLayerMinDepth() + dimension.getTopLayerVariation()));
        HashMap<Layer, Integer> usedLayers = new HashMap<Layer, Integer>();
        EnumSet<Terrain> terrainsUsed = EnumSet.noneOf(Terrain.class);
        float lowestSurface = Float.MAX_VALUE;
        float highestSurface = -3.4028235E38f;
        int lowestWaterlevel = Integer.MAX_VALUE;
        int highestWaterlevel = Integer.MIN_VALUE;
        for (Tile tile : dimension.getTiles()) {
            for (Layer layer2 : tile.getLayers()) {
                Integer count = (Integer)usedLayers.get(layer2);
                if (count == null) {
                    usedLayers.put(layer2, 1);
                    continue;
                }
                usedLayers.put(layer2, count + 1);
            }
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    int waterLevel;
                    terrainsUsed.add(tile.getTerrain(x, y));
                    float height = tile.getHeight(x, y);
                    if (height < lowestSurface) {
                        lowestSurface = height;
                    }
                    if (height > highestSurface) {
                        highestSurface = height;
                    }
                    if ((waterLevel = tile.getWaterLevel(x, y)) < lowestWaterlevel) {
                        lowestWaterlevel = waterLevel;
                    }
                    if (waterLevel <= highestWaterlevel) continue;
                    highestWaterlevel = waterLevel;
                }
            }
        }
        System.out.println("    Terrain heights: " + lowestSurface + " - " + highestSurface);
        System.out.println("    Water levels: " + lowestWaterlevel + " - " + highestWaterlevel);
        if (dimension.getCustomBiomes() != null && !dimension.getCustomBiomes().isEmpty()) {
            System.out.println("    Custom biomes installed:");
            dimension.getCustomBiomes().forEach(customBiome -> System.out.println("        " + customBiome.getName() + " (" + customBiome.getId() + ")"));
        } else {
            System.out.println("    No custom biomes installed");
        }
        System.out.println("    Layers used:");
        usedLayers.entrySet().forEach(entry -> {
            Layer layer = (Layer)entry.getKey();
            System.out.println("        Name: " + layer.getName());
            System.out.println("            Type: " + layer.getClass().getSimpleName());
            System.out.println("            Data size: " + layer.getDataSize());
            System.out.println("            Tile count: " + entry.getValue());
        });
        HashSet unusedLayers = new HashSet(dimension.getCustomLayers());
        unusedLayers.removeAll(usedLayers.keySet());
        if (!unusedLayers.isEmpty()) {
            System.out.println("    Layers stored but not in use:");
            unusedLayers.forEach(layer -> {
                System.out.println("        Name: " + layer.getName());
                System.out.println("            Type: " + layer.getClass().getSimpleName());
                System.out.println("            Data size: " + layer.getDataSize());
            });
        }
        System.out.println("    Terrain types used:");
        terrainsUsed.forEach(terrain -> System.out.println("        " + terrain.getName() + " (index: " + terrain.ordinal() + ")"));
        ArrayList<CallSite> problems = new ArrayList<CallSite>();
        if (dimension.getAnchor().dim != 0 && dimension.getMaxHeight() != dimension.getWorld().getMaxHeight()) {
            problems.add((CallSite)((Object)("Dimension max height (" + dimension.getMaxHeight() + ") does not equal the world max height (" + dimension.getWorld().getMaxHeight() + ")")));
        }
        for (Terrain terrain2 : terrainsUsed) {
            if (!terrain2.isCustom() || terrain2.isConfigured()) continue;
            problems.add((CallSite)((Object)("Unconfigured custom terrain type " + terrain2.getName() + " (index: " + terrain2.ordinal() + ") encountered")));
        }
        if (!problems.isEmpty()) {
            System.out.println("    PROBLEMS:");
            problems.forEach(problem -> System.out.println("        " + problem));
        }
    }
}

