/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.pepsoft.util.ColourUtils;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiomesTileProvider
implements TileProvider {
    private final ColourScheme colourScheme;
    private int biomeAlgorithm;
    private long minecraftSeed;
    private final ThreadLocal<int[][]> biomeCountsRef = new ThreadLocal();
    private final int patternColour;
    private final boolean fade;
    private BiomeScheme biomeScheme;
    private int zoom;
    private volatile ThreadLocal<int[]> bufferRef = new ThreadLocal();
    private int[] biomeColours;
    private boolean[][][] biomePatterns;
    private volatile boolean enabled = true;
    private static final ThreadLocal<BufferedImage> renderBufferRef = new ThreadLocal<BufferedImage>(){

        @Override
        protected BufferedImage initialValue() {
            return new BufferedImage(128, 128, 2);
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(BiomesTileProvider.class);
    private static final int[] BIOME_PRIORITIES = new int[256];

    public BiomesTileProvider(BiomeScheme biomeScheme, ColourScheme colourScheme) {
        this(biomeScheme, colourScheme, 2, false);
    }

    public BiomesTileProvider(BiomeScheme biomeScheme, ColourScheme colourScheme, int zoom, boolean fade) {
        this.biomeScheme = biomeScheme;
        this.colourScheme = colourScheme;
        this.zoom = zoom;
        this.fade = fade;
        this.patternColour = fade ? -8355712 : -16777216;
        this.init();
    }

    public BiomesTileProvider(int biomeAlgorithm, long minecraftSeed, ColourScheme colourScheme, int zoom, boolean fade) {
        this.biomeAlgorithm = biomeAlgorithm;
        this.colourScheme = colourScheme;
        this.minecraftSeed = minecraftSeed;
        this.zoom = zoom;
        this.fade = fade;
        this.patternColour = fade ? -8355712 : -16777216;
    }

    public int getTileSize() {
        return 128;
    }

    public boolean isZoomSupported() {
        return true;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (zoom != this.zoom) {
            if (zoom > 0) {
                throw new UnsupportedOperationException("Zooming in not supported");
            }
            this.zoom = zoom;
            this.bufferRef = new ThreadLocal();
        }
    }

    public boolean isTilePresent(int x, int y) {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintTile(Image image, int tileX, int tileY, int imageX, int imageY) {
        if (!this.enabled) {
            return false;
        }
        try {
            BiomeScheme biomeScheme = this.getBiomeScheme();
            if (biomeScheme == null) {
                return false;
            }
            int scale = 1 << -this.zoom;
            int[] buffer = this.bufferRef.get();
            if (buffer == null) {
                buffer = new int[16384 * scale * scale];
                this.bufferRef.set(buffer);
            }
            biomeScheme.getBiomes(tileX * 128 * scale, tileY * 128 * scale, 128 * scale, 128 * scale, buffer);
            BufferedImage tile = renderBufferRef.get();
            Object biomeCounts = this.biomeCountsRef.get();
            if (biomeCounts == null) {
                biomeCounts = new int[][]{new int[256], new int[256], new int[256]};
                this.biomeCountsRef.set((int[][])biomeCounts);
            }
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < biomeCounts[i].length; ++j) {
                            biomeCounts[i][j] = 0;
                        }
                    }
                    for (int dx = 0; dx < scale; ++dx) {
                        for (int dz = 0; dz < scale; ++dz) {
                            int biome = buffer[x * scale + dx + (y * scale + dz) * 128 * scale];
                            int[] nArray = biomeCounts[BIOME_PRIORITIES[biome]];
                            int n = biome;
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                    int mostCommonBiome = -1;
                    for (int i = 2; i >= 0; --i) {
                        int mostCommonBiomeCount = 0;
                        for (int j = 0; j < biomeCounts[i].length; ++j) {
                            if (biomeCounts[i][j] <= mostCommonBiomeCount) continue;
                            mostCommonBiome = j;
                            mostCommonBiomeCount = biomeCounts[i][j];
                        }
                        if (mostCommonBiome != -1) break;
                    }
                    if (this.biomePatterns[mostCommonBiome] != null && this.biomePatterns[mostCommonBiome][x % 16][y % 16]) {
                        tile.setRGB(x, y, this.patternColour);
                        continue;
                    }
                    tile.setRGB(x, y, this.biomeColours[mostCommonBiome]);
                }
            }
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            try {
                g2.drawImage((Image)tile, imageX, imageY, null);
            }
            finally {
                g2.dispose();
            }
        }
        catch (Throwable t) {
            logger.error("Exception while generating image for tile at {}, {}", new Object[]{tileX, tileY, t});
        }
        return true;
    }

    public int getTilePriority(int x, int y) {
        return 0;
    }

    public Rectangle getExtent() {
        return null;
    }

    public void addTileListener(TileListener tileListener) {
    }

    public void removeTileListener(TileListener tileListener) {
    }

    private synchronized BiomeScheme getBiomeScheme() {
        if (this.biomeScheme == null) {
            try {
                this.biomeScheme = BiomeSchemeManager.getSharedBiomeScheme((int)this.biomeAlgorithm);
                if (this.biomeScheme == null) {
                    switch (this.biomeAlgorithm) {
                        case 9: {
                            this.biomeScheme = BiomeSchemeManager.getSharedBiomeScheme((int)5);
                            break;
                        }
                        case 10: {
                            this.biomeScheme = BiomeSchemeManager.getSharedBiomeScheme((int)8);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("An exception occurred while trying to load or initialize Minecraft jar; continuing without showing biomes", (Throwable)e);
            }
            catch (Error e) {
                logger.error("An error occurred while trying to load or initialize Minecraft jar; continuing without showing biomes", (Throwable)e);
            }
            if (this.biomeScheme != null) {
                this.biomeScheme.setSeed(this.minecraftSeed);
                this.init();
            } else {
                this.enabled = false;
            }
        }
        return this.biomeScheme;
    }

    private void init() {
        int biomeCount = this.biomeScheme.getBiomeCount();
        this.biomeColours = new int[biomeCount];
        this.biomePatterns = new boolean[biomeCount][][];
        for (int i = 0; i < biomeCount; ++i) {
            if (!this.biomeScheme.isBiomePresent(i)) continue;
            this.biomeColours[i] = 0xFF000000 | (this.fade ? ColourUtils.mix((int)0xFFFFFF, (int)this.biomeScheme.getColour(i, this.colourScheme)) : this.biomeScheme.getColour(i, this.colourScheme));
            this.biomePatterns[i] = this.biomeScheme.getPattern(i);
        }
    }

    static {
        Arrays.fill(BIOME_PRIORITIES, 1);
        BiomesTileProvider.BIOME_PRIORITIES[0] = 0;
        BiomesTileProvider.BIOME_PRIORITIES[10] = 0;
        BiomesTileProvider.BIOME_PRIORITIES[24] = 0;
        BiomesTileProvider.BIOME_PRIORITIES[7] = 2;
        BiomesTileProvider.BIOME_PRIORITIES[11] = 2;
    }
}

