/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.threedeeview;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MissingCustomTerrainException;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.TileProvider;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresent;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.layers.ReadOnly;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.AnnotationsExporter;
import org.pepsoft.worldpainter.threedeeview.ThreeDeeView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tile3DRenderer {
    private final Dimension dimension;
    private final ColourScheme colourScheme;
    private final TileRenderer tileRenderer;
    private final int minHeight;
    private final int rotation;
    private final int stoneColour;
    private final int waterColour;
    private final int lavaColour;
    private final int iceColour;
    private final Platform platform;
    private final boolean hideFrost;
    private final boolean hideFluids;
    private final BufferedImage tileImgBuffer = new BufferedImage(128, 128, 1);
    static final Set<Layer> ALWAYS_HIDDEN_LAYERS = Collections.singleton(TileRenderer.FLUIDS_AS_LAYER);
    static final Set<Layer> DEFAULT_HIDDEN_LAYERS = new HashSet<Layer>(Arrays.asList(Biome.INSTANCE, Caverns.INSTANCE, Caves.INSTANCE, Chasms.INSTANCE, ReadOnly.INSTANCE, Resources.INSTANCE, TileRenderer.ALL_TUNNELS_AS_LAYER));
    private static final Logger logger;

    public Tile3DRenderer(Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int rotation, LayerVisibilityMode layerVisibility, Set<Layer> hiddenLayers) {
        this.dimension = dimension;
        this.minHeight = dimension.getMinHeight();
        this.colourScheme = colourScheme;
        this.rotation = rotation;
        this.tileRenderer = new TileRenderer((TileProvider)dimension, colourScheme, customBiomeManager, 0, true, null);
        switch (layerVisibility) {
            case NONE: {
                this.tileRenderer.setHideAllLayers(true);
                this.tileRenderer.addHiddenLayers(ALWAYS_HIDDEN_LAYERS);
                this.hideFrost = true;
                this.hideFluids = false;
                break;
            }
            case SYNC: {
                this.tileRenderer.addHiddenLayers(hiddenLayers);
                this.tileRenderer.addHiddenLayers(ALWAYS_HIDDEN_LAYERS);
                this.hideFrost = hiddenLayers.contains(Frost.INSTANCE);
                this.hideFluids = hiddenLayers.contains(TileRenderer.FLUIDS_AS_LAYER);
                break;
            }
            case SURFACE: {
                this.tileRenderer.addHiddenLayers(DEFAULT_HIDDEN_LAYERS);
                this.hideFrost = false;
                this.hideFluids = false;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (!(layerVisibility == LayerVisibilityMode.NONE || dimension.getLayerSettings((Layer)Annotations.INSTANCE) != null && ((AnnotationsExporter.AnnotationsSettings)dimension.getLayerSettings((Layer)Annotations.INSTANCE)).isExport())) {
            this.tileRenderer.addHiddenLayers(Collections.singleton(Annotations.INSTANCE));
        }
        this.tileRenderer.setContourLines(false);
        switch (dimension.getAnchor().dim) {
            case 1: {
                this.stoneColour = colourScheme.getColour(Material.NETHERRACK);
                break;
            }
            case 2: {
                this.stoneColour = colourScheme.getColour(Material.END_STONE);
                break;
            }
            default: {
                this.stoneColour = colourScheme.getColour(Material.STONE);
            }
        }
        this.waterColour = colourScheme.getColour(Material.WATER);
        this.lavaColour = colourScheme.getColour(Material.LAVA);
        this.iceColour = colourScheme.getColour(Material.ICE);
        this.platform = this.tileRenderer.getPlatform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage render(Tile tile) {
        this.tileRenderer.renderTile(tile, (Image)this.tileImgBuffer, 0, 0);
        long seed = this.dimension.getSeed();
        boolean coverSteepTerrain = this.dimension.isCoverSteepTerrain();
        boolean topLayersRelativeToTerrain = this.dimension.getTopLayerAnchor() == Dimension.LayerAnchor.TERRAIN;
        int tileOffsetX = tile.getX() * 128;
        int tileOffsetY = tile.getY() * 128;
        int currentColour = -1;
        int imgWidth = 256;
        int maxZ = Math.max(tile.getHighestIntHeight(), tile.getHighestWaterLevel());
        int imgHeight = 128 + maxZ - this.minHeight;
        long tileImgSize = 256L * (long)imgHeight;
        if (tileImgSize < 0L) return ThreeDeeView.TILE_NOT_RENDERABLE;
        if (tileImgSize > Integer.MAX_VALUE) {
            return ThreeDeeView.TILE_NOT_RENDERABLE;
        }
        BufferedImage img = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, imgHeight, 3);
        Graphics2D g2 = img.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            int x = 0;
            block11: while (true) {
                if (x >= 128) return img;
                int y = 0;
                while (true) {
                    block29: {
                        int z;
                        int colour;
                        float imgY;
                        float imgX;
                        boolean floodWithLava;
                        int fluidLevel;
                        int terrainHeight;
                        int yInTile;
                        int xInTile;
                        block31: {
                            Material nextMaterial;
                            int topLayerOffset;
                            MixedMaterial mixedMaterial;
                            Terrain terrain;
                            int blockY;
                            int blockX;
                            block32: {
                                block28: {
                                    int subsurfaceHeight;
                                    block30: {
                                        if (y >= 128) break block28;
                                        switch (this.rotation) {
                                            case 0: {
                                                xInTile = x;
                                                yInTile = y;
                                                break;
                                            }
                                            case 1: {
                                                xInTile = y;
                                                yInTile = 127 - x;
                                                break;
                                            }
                                            case 2: {
                                                xInTile = 127 - x;
                                                yInTile = 127 - y;
                                                break;
                                            }
                                            case 3: {
                                                xInTile = 127 - y;
                                                yInTile = x;
                                                break;
                                            }
                                            default: {
                                                throw new IllegalArgumentException();
                                            }
                                        }
                                        if (tile.getBitLayerValue((Layer)Void.INSTANCE, xInTile, yInTile) || tile.getBitLayerValue((Layer)NotPresent.INSTANCE, xInTile, yInTile) || tile.getBitLayerValue((Layer)NotPresentBlock.INSTANCE, xInTile, yInTile)) break block29;
                                        blockX = tileOffsetX + xInTile;
                                        blockY = tileOffsetY + yInTile;
                                        terrainHeight = tile.getIntHeight(xInTile, yInTile);
                                        fluidLevel = tile.getWaterLevel(xInTile, yInTile);
                                        floodWithLava = fluidLevel > terrainHeight ? tile.getBitLayerValue((Layer)FloodWithLava.INSTANCE, xInTile, yInTile) : false;
                                        imgX = (float)(128 + x - y) - 0.5f;
                                        imgY = (float)(x + y) / 2.0f + (float)maxZ - (float)this.minHeight + 0.5f;
                                        subsurfaceHeight = Math.max(terrainHeight - this.minHeight - this.dimension.getTopLayerDepth(blockX, blockY, terrainHeight), 0);
                                        if (coverSteepTerrain) {
                                            subsurfaceHeight = Math.min(subsurfaceHeight, Math.min(Math.min(this.dimension.getIntHeightAt(blockX - 1, blockY, Integer.MAX_VALUE), this.dimension.getIntHeightAt(blockX + 1, blockY, Integer.MAX_VALUE)), Math.min(this.dimension.getIntHeightAt(blockX, blockY - 1, Integer.MAX_VALUE), this.dimension.getIntHeightAt(blockX, blockY + 1, Integer.MAX_VALUE))) - this.minHeight);
                                        }
                                        if ((colour = this.stoneColour) != currentColour) {
                                            g2.setColor(new Color(colour));
                                            currentColour = colour;
                                        }
                                        if (subsurfaceHeight > 0) {
                                            g2.fill(new Rectangle2D.Float(imgX, imgY - (float)subsurfaceHeight, 2.0f, subsurfaceHeight));
                                        }
                                        if ((terrain = tile.getTerrain(xInTile, yInTile)).isCustom()) {
                                            mixedMaterial = Terrain.getCustomMaterial((int)terrain.getCustomTerrainIndex());
                                            topLayerOffset = topLayersRelativeToTerrain && mixedMaterial.getMode() == MixedMaterial.Mode.LAYERED ? -(terrainHeight - mixedMaterial.getPatternHeight() + 1) : 0;
                                        } else {
                                            mixedMaterial = null;
                                            topLayerOffset = 0;
                                        }
                                        if (mixedMaterial == null || mixedMaterial.getColour() == null) break block30;
                                        colour = mixedMaterial.getColour();
                                        if (colour != currentColour) {
                                            g2.setColor(new Color(colour));
                                            currentColour = colour;
                                        }
                                        g2.fill(new Rectangle2D.Float(imgX, imgY - (float)terrainHeight + (float)this.minHeight + 1.0f, 2.0f, terrainHeight - this.minHeight - subsurfaceHeight - 1));
                                        break block31;
                                    }
                                    nextMaterial = terrain.getMaterial(this.platform, seed, blockX, blockY, subsurfaceHeight + this.minHeight + 1, terrainHeight);
                                    break block32;
                                }
                                ++x;
                                continue block11;
                            }
                            for (z = subsurfaceHeight + this.minHeight + 1; z <= terrainHeight - 1; ++z) {
                                Material material = nextMaterial;
                                if (z < maxZ) {
                                    nextMaterial = terrain.getMaterial(this.platform, seed, blockX, blockY, z + 1, terrainHeight);
                                    if (!(nextMaterial.veryInsubstantial || material != Material.GRASS_BLOCK && material != Material.MYCELIUM && material != Material.FARMLAND)) {
                                        material = Material.DIRT;
                                    }
                                }
                                if ((colour = topLayerOffset != 0 ? this.colourScheme.getColour(mixedMaterial.getMaterial(seed, blockX, blockY, z + topLayerOffset)) : this.colourScheme.getColour(material)) != currentColour) {
                                    g2.setColor(new Color(colour));
                                    currentColour = colour;
                                }
                                g2.draw(new Line2D.Float(imgX, imgY - (float)z + (float)this.minHeight, imgX + 1.0f, imgY - (float)z + (float)this.minHeight));
                            }
                        }
                        colour = this.tileImgBuffer.getRGB(xInTile, yInTile);
                        if (colour != currentColour) {
                            g2.setColor(new Color(colour));
                            currentColour = colour;
                        }
                        g2.draw(new Line2D.Float(imgX, imgY - (float)terrainHeight + (float)this.minHeight, imgX + 1.0f, imgY - (float)terrainHeight + (float)this.minHeight));
                        if (!this.hideFluids && fluidLevel > terrainHeight) {
                            colour = floodWithLava ? this.lavaColour : this.waterColour;
                            currentColour = colour & 0xFFFFFF | 0x60000000;
                            g2.setColor(new Color(currentColour, true));
                            boolean ice = !floodWithLava && !this.hideFrost && tile.getBitLayerValue((Layer)Frost.INSTANCE, xInTile, yInTile);
                            for (z = terrainHeight + 1; z <= fluidLevel; ++z) {
                                if (z == fluidLevel && ice) {
                                    colour = this.iceColour;
                                    g2.setColor(new Color(colour));
                                    currentColour = colour;
                                }
                                g2.draw(new Line2D.Float(imgX, imgY - (float)z + (float)this.minHeight, imgX + 1.0f, imgY - (float)z + (float)this.minHeight));
                            }
                        }
                    }
                    ++y;
                }
                break;
            }
        }
        catch (NullPointerException | MissingCustomTerrainException e) {
            logger.error("Could not render tile {},{} due to {}", new Object[]{tile.getX(), tile.getY(), e.getClass().getSimpleName(), e});
            BufferedImage bufferedImage = ThreeDeeView.TILE_NOT_RENDERABLE;
            return bufferedImage;
        }
        finally {
            g2.dispose();
        }
    }

    static {
        DEFAULT_HIDDEN_LAYERS.addAll(ALWAYS_HIDDEN_LAYERS);
        logger = LoggerFactory.getLogger(Tile3DRenderer.class);
    }

    public static enum LayerVisibilityMode {
        NONE,
        SYNC,
        SURFACE;

    }
}

