/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.threedeeview;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.Overlay;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.threedeeview.RenderResult;
import org.pepsoft.worldpainter.threedeeview.ThreeDeeRenderManager;
import org.pepsoft.worldpainter.threedeeview.Tile3DRenderer;

public class ThreeDeeView
extends JComponent
implements Dimension.Listener,
Tile.Listener,
HierarchyListener,
ActionListener,
Scrollable {
    private final Dimension dimension;
    private final Map<Tile, BufferedImage> renderedTiles = new HashMap<Tile, BufferedImage>();
    private final Map<Tile, BufferedImage> dirtyTiles = new HashMap<Tile, BufferedImage>();
    private final ThreeDeeRenderManager threeDeeRenderManager;
    private final ColourScheme colourScheme;
    private final List<Tile> tilesWaitingToBeRendered = new LinkedList<Tile>();
    private final int minHeight;
    private final int maxHeight;
    private final int xOffset;
    private final int yOffset;
    private final int maxX;
    private final int maxY;
    private final int rotation;
    private final SortedMap<Integer, SortedMap<Integer, Tile>> zSortedTiles;
    private final CustomBiomeManager customBiomeManager;
    private final boolean upsideDown;
    private Timer timer;
    private long lastTileChange;
    private RefreshMode refreshMode = RefreshMode.DELAYED;
    private Tile centreTile;
    private int waterLevel;
    private int zoom = 1;
    private int scale = 1;
    private Point highlightTile;
    private Point highlightPoint;
    private Tile3DRenderer.LayerVisibilityMode layerVisibility;
    private Set<Layer> hiddenLayers;
    public static final BufferedImage TILE_NOT_RENDERABLE = new BufferedImage(1, 1, 12);
    private static final long serialVersionUID = 2011101701L;

    public ThreeDeeView(Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int rotation, int zoom) {
        this.dimension = dimension;
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.rotation = rotation;
        this.zoom = zoom;
        this.scale = (int)Math.pow(2.0, Math.abs(zoom - 1));
        this.minHeight = dimension.getMinHeight();
        this.maxHeight = dimension.getMaxHeight();
        this.waterLevel = dimension.getTileFactory() instanceof HeightMapTileFactory ? ((HeightMapTileFactory)dimension.getTileFactory()).getWaterHeight() : 62;
        this.upsideDown = dimension.getAnchor().invert;
        this.zSortedTiles = new TreeMap<Integer, SortedMap<Integer, Tile>>();
        for (Tile tile : dimension.getTiles()) {
            Rectangle tileBaseBounds = this.getTileBounds(tile.getX(), tile.getY(), 0, 0, 0);
            this.zSortedTiles.computeIfAbsent(tileBaseBounds.y, y -> new TreeMap()).put(tileBaseBounds.x, tile);
        }
        this.threeDeeRenderManager = new ThreeDeeRenderManager(dimension, colourScheme, customBiomeManager, rotation);
        dimension.addDimensionListener((Dimension.Listener)this);
        for (Tile tile : dimension.getTiles()) {
            tile.addListener((Tile.Listener)this);
        }
        int width = dimension.getWidth() * 128 + dimension.getHeight() * 128;
        int height = width / 2 + this.maxHeight - this.minHeight - 1;
        this.maxY = 0;
        this.maxX = 0;
        switch (rotation) {
            case 0: {
                this.xOffset = -this.getTileBounds((int)dimension.getLowestX(), (int)dimension.getHighestY(), (int)this.maxHeight).x;
                this.yOffset = -this.getTileBounds((int)dimension.getLowestX(), (int)dimension.getLowestY(), (int)this.maxHeight).y;
                break;
            }
            case 1: {
                this.xOffset = -this.getTileBounds((int)dimension.getHighestX(), (int)dimension.getHighestY(), (int)this.maxHeight).x;
                this.yOffset = -this.getTileBounds((int)dimension.getLowestX(), (int)dimension.getHighestY(), (int)this.maxHeight).y;
                break;
            }
            case 2: {
                this.xOffset = -this.getTileBounds((int)dimension.getHighestX(), (int)dimension.getLowestY(), (int)this.maxHeight).x;
                this.yOffset = -this.getTileBounds((int)dimension.getHighestX(), (int)dimension.getHighestY(), (int)this.maxHeight).y;
                break;
            }
            case 3: {
                this.xOffset = -this.getTileBounds((int)dimension.getLowestX(), (int)dimension.getLowestY(), (int)this.maxHeight).x;
                this.yOffset = -this.getTileBounds((int)dimension.getHighestX(), (int)dimension.getLowestY(), (int)this.maxHeight).y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        java.awt.Dimension preferredSize = this.zoom(new java.awt.Dimension(width, height));
        this.setPreferredSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.setMaximumSize(preferredSize);
        this.setSize(preferredSize);
        this.addHierarchyListener(this);
    }

    public RefreshMode getRefreshMode() {
        return this.refreshMode;
    }

    public void setRefreshMode(RefreshMode refreshMode) {
        this.refreshMode = refreshMode;
    }

    public Rectangle getImageBounds() {
        Rectangle imageBounds = null;
        for (Map map : this.zSortedTiles.values()) {
            for (Tile tile : map.values()) {
                if (imageBounds == null) {
                    imageBounds = this.getTileBounds(tile);
                    continue;
                }
                imageBounds = imageBounds.union(this.getTileBounds(tile));
            }
        }
        return imageBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage(Rectangle imageBounds, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        Tile3DRenderer renderer = new Tile3DRenderer(this.dimension, this.colourScheme, this.customBiomeManager, this.rotation, this.layerVisibility, this.hiddenLayers);
        int tileCount = this.zSortedTiles.values().stream().mapToInt(Map::size).sum();
        BufferedImage image = new BufferedImage(imageBounds.width, imageBounds.height, 2);
        Graphics2D g2 = image.createGraphics();
        try {
            int tileNo = 0;
            for (Map map : this.zSortedTiles.values()) {
                for (Tile tile : map.values()) {
                    Rectangle tileBounds = this.getTileBounds(tile);
                    g2.drawImage((Image)renderer.render(tile), tileBounds.x - imageBounds.x, tileBounds.y - imageBounds.y, null);
                    if (progressReceiver == null) continue;
                    progressReceiver.setProgress((float)(++tileNo) / (float)tileCount);
                }
            }
        }
        finally {
            g2.dispose();
        }
        return image;
    }

    public Point worldToView(int x, int y) {
        switch (this.rotation) {
            case 0: {
                return this.zoom(new Point(this.xOffset + 128 + x - y, this.yOffset + this.maxHeight - this.minHeight - 1 - 64 + (y + x) / 2));
            }
            case 1: {
                return this.zoom(new Point(this.xOffset + 256 - x - y, this.yOffset + this.maxHeight - this.minHeight - 1 - (y - x) / 2));
            }
            case 2: {
                return this.zoom(new Point(this.xOffset + 128 - x + y, this.yOffset + this.maxHeight - this.minHeight - 1 + 64 - (y + x) / 2));
            }
            case 3: {
                return this.zoom(new Point(this.xOffset + x + y, this.yOffset + this.maxHeight - this.minHeight - 1 + (y - x) / 2));
            }
        }
        throw new IllegalArgumentException();
    }

    public Tile getCentreMostTile() {
        return this.centreTile;
    }

    public Point getHighlightTile() {
        return this.highlightTile;
    }

    public void setHighlightTile(Point highlightTile) {
        this.highlightTile = highlightTile;
        this.repaint();
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
        this.scale = (int)Math.pow(2.0, Math.abs(zoom - 1));
        int width = this.dimension.getWidth() * 128 + this.dimension.getHeight() * 128;
        int height = width / 2 + this.maxHeight - this.minHeight - 1;
        java.awt.Dimension preferredSize = this.zoom(new java.awt.Dimension(width, height));
        this.setPreferredSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.setMaximumSize(preferredSize);
        this.setSize(preferredSize);
        this.repaint();
    }

    public void setLayerVisibility(Tile3DRenderer.LayerVisibilityMode layerVisibility) {
        if (layerVisibility != this.layerVisibility) {
            this.layerVisibility = layerVisibility;
            this.threeDeeRenderManager.setLayerVisibility(layerVisibility);
            this.refresh(false);
        }
    }

    public void setHiddenLayers(Set<Layer> hiddenLayers) {
        if (!Objects.equals(hiddenLayers, this.hiddenLayers)) {
            this.hiddenLayers = hiddenLayers;
            this.threeDeeRenderManager.setHiddenLayers(hiddenLayers);
            if (this.layerVisibility == Tile3DRenderer.LayerVisibilityMode.SYNC) {
                this.refresh(false);
            }
        }
    }

    public void moveToTile(Tile tile) {
        Rectangle tileBounds = this.zoom(this.getTileBounds(tile));
        this.moveTo(new Point(tileBounds.x + tileBounds.width / 2, tileBounds.y + tileBounds.height - 64));
    }

    public void moveTo(int x, int y) {
        Point coords = this.worldToView(x, y);
        this.moveTo(coords);
    }

    public void refresh(boolean clear) {
        this.threeDeeRenderManager.stop();
        if (clear) {
            this.renderedTiles.clear();
            this.dirtyTiles.clear();
        } else {
            this.dirtyTiles.putAll(this.renderedTiles);
            this.renderedTiles.clear();
        }
        this.repaint();
    }

    public void tilesAdded(Dimension dimension, Set<Tile> tiles) {
        tiles.forEach(tile -> {
            Rectangle tileBaseBounds = this.getTileBounds(tile.getX(), tile.getY(), 0, 0, 0);
            this.zSortedTiles.computeIfAbsent(tileBaseBounds.y, y -> new TreeMap()).put(tileBaseBounds.x, tile);
            tile.addListener((Tile.Listener)this);
        });
    }

    public void tilesRemoved(Dimension dimension, Set<Tile> tiles) {
        for (Tile tile : tiles) {
            tile.removeListener((Tile.Listener)this);
            Rectangle tileBaseBounds = this.getTileBounds(tile.getX(), tile.getY(), 0, 0, 0);
            if (!this.zSortedTiles.containsKey(tileBaseBounds.y)) continue;
            ((SortedMap)this.zSortedTiles.get(tileBaseBounds.y)).remove(tileBaseBounds.x);
        }
    }

    public void overlayAdded(Dimension dimension, int index, Overlay overlay) {
    }

    public void overlayRemoved(Dimension dimension, int index, Overlay overlay) {
    }

    public void heightMapChanged(Tile tile) {
        this.scheduleTileForRendering(tile);
    }

    public void terrainChanged(Tile tile) {
        this.scheduleTileForRendering(tile);
    }

    public void waterLevelChanged(Tile tile) {
        this.scheduleTileForRendering(tile);
    }

    public void seedsChanged(Tile tile) {
        this.scheduleTileForRendering(tile);
    }

    public void layerDataChanged(Tile tile, Set<Layer> changedLayers) {
        for (Layer layer : changedLayers) {
            if ((this.layerVisibility != Tile3DRenderer.LayerVisibilityMode.SURFACE || Tile3DRenderer.DEFAULT_HIDDEN_LAYERS.contains(layer)) && this.layerVisibility != Tile3DRenderer.LayerVisibilityMode.SYNC && !(layer instanceof Void)) continue;
            this.scheduleTileForRendering(tile);
            return;
        }
    }

    public void allBitLayerDataChanged(Tile tile) {
        this.scheduleTileForRendering(tile);
    }

    public void allNonBitlayerDataChanged(Tile tile) {
        this.scheduleTileForRendering(tile);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        if ((event.getChangeFlags() & 2L) != 0L) {
            if (this.isDisplayable()) {
                this.timer = new Timer(250, this);
                this.timer.start();
            } else {
                this.timer.stop();
                this.timer = null;
                this.threeDeeRenderManager.stop();
                for (Tile tile : this.dimension.getTiles()) {
                    tile.removeListener((Tile.Listener)this);
                }
                this.dimension.removeDimensionListener((Dimension.Listener)this);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.tilesWaitingToBeRendered.isEmpty() && System.currentTimeMillis() - this.lastTileChange > 250L) {
            this.tilesWaitingToBeRendered.forEach(this.threeDeeRenderManager::renderTile);
            this.tilesWaitingToBeRendered.clear();
        }
        Set<RenderResult> renderResults = this.threeDeeRenderManager.getRenderedTiles();
        Rectangle repaintArea = null;
        for (RenderResult renderResult : renderResults) {
            Tile tile = renderResult.getTile();
            this.renderedTiles.put(tile, renderResult.getImage());
            this.dirtyTiles.remove(tile);
            Rectangle tileBounds = this.zoom(this.getTileBounds(tile));
            if (repaintArea == null) {
                repaintArea = tileBounds;
                continue;
            }
            repaintArea = repaintArea.union(tileBounds);
        }
        if (repaintArea != null) {
            this.repaint(repaintArea);
        }
    }

    @Override
    public java.awt.Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.zoom != 1) {
            double scaleFactor = Math.pow(2.0, this.zoom - 1);
            g2.scale(scaleFactor, scaleFactor);
            if (this.zoom > 1) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        if (this.upsideDown) {
            g2.scale(1.0, -1.0);
            g2.translate(0, -this.getHeight());
        }
        Rectangle visibleRect = this.unzoom(this.getVisibleRect());
        int centerX = visibleRect.x + visibleRect.width / 2;
        int centerY = visibleRect.y + visibleRect.height / 2 + this.waterLevel;
        Tile mostCentredTile = null;
        int smallestDistance = Integer.MAX_VALUE;
        Rectangle clipBounds = g2.getClipBounds();
        for (SortedMap<Integer, Tile> row : this.zSortedTiles.subMap(clipBounds.y - this.yOffset - this.maxHeight, clipBounds.y + clipBounds.height - this.yOffset + this.maxHeight).values()) {
            for (Tile tile : row.subMap(clipBounds.x - this.xOffset - 256, clipBounds.x + clipBounds.width - this.xOffset).values()) {
                BufferedImage tileImg;
                Rectangle tileBounds = this.getTileBounds(tile);
                if (!tileBounds.intersects(clipBounds)) continue;
                int dx = tileBounds.x + tileBounds.width / 2 - centerX;
                int dy = tileBounds.y + tileBounds.height - 64 - centerY;
                int dist = (int)Math.sqrt(dx * dx + dy * dy);
                if (dist < smallestDistance) {
                    smallestDistance = dist;
                    mostCentredTile = tile;
                }
                if ((tileImg = this.renderedTiles.get(tile)) == null) {
                    this.tilesWaitingToBeRendered.add(0, tile);
                    tileImg = this.dirtyTiles.get(tile);
                }
                if (tileImg == null) continue;
                if (tileImg != TILE_NOT_RENDERABLE) {
                    g2.drawImage((Image)tileImg, tileBounds.x, tileBounds.y, null);
                    continue;
                }
                g2.setColor(Color.RED);
                g2.drawRect(tileBounds.x, tileBounds.y, tileBounds.width, tileBounds.height);
                g2.drawLine(tileBounds.x, tileBounds.y, tileBounds.x + tileBounds.width, tileBounds.y + tileBounds.height);
                g2.drawLine(tileBounds.x + tileBounds.width, tileBounds.y, tileBounds.x, tileBounds.y + tileBounds.height);
            }
        }
        if (mostCentredTile != null) {
            this.centreTile = mostCentredTile;
        }
        if (this.highlightTile != null) {
            g2.setColor(Color.RED);
            Rectangle rect = this.getTileBounds(this.highlightTile.x, this.highlightTile.y, this.maxHeight);
            g2.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.highlightPoint != null) {
            g2.setColor(Color.RED);
            g2.drawLine(this.highlightPoint.x - 2, this.highlightPoint.y, this.highlightPoint.x + 2, this.highlightPoint.y);
            g2.drawLine(this.highlightPoint.x, this.highlightPoint.y - 2, this.highlightPoint.x, this.highlightPoint.y + 2);
        }
    }

    private void scheduleTileForRendering(Tile tile) {
        JViewport parent = (JViewport)this.getParent();
        if (parent == null) {
            return;
        }
        AwtUtils.doOnEventThread(() -> {
            block6: {
                block5: {
                    Rectangle visibleArea = parent.getViewRect();
                    Rectangle tileBounds = this.zoom(this.getTileBounds(tile));
                    if (!tileBounds.intersects(visibleArea)) break block5;
                    switch (this.refreshMode) {
                        case IMMEDIATE: {
                            this.threeDeeRenderManager.renderTile(tile);
                            break block6;
                        }
                        case DELAYED: {
                            this.tilesWaitingToBeRendered.add(tile);
                            this.lastTileChange = System.currentTimeMillis();
                            break block6;
                        }
                        case MANUAL: {
                            break block6;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                this.tilesWaitingToBeRendered.remove(tile);
                this.renderedTiles.remove(tile);
            }
        });
    }

    private Rectangle getTileBounds(Tile tile) {
        return this.getTileBounds(tile.getX(), tile.getY(), Math.max(tile.getHighestIntHeight(), tile.getHighestWaterLevel()) + 1);
    }

    private Rectangle getTileBounds(int x, int y, int maxHeight) {
        return this.getTileBounds(x, y, maxHeight, this.xOffset, this.yOffset);
    }

    private Rectangle getTileBounds(int x, int y, int maxHeight, int xOffset, int yOffset) {
        switch (this.rotation) {
            case 0: {
                return new Rectangle(xOffset + (x - y) * 128, yOffset + (x + y) * 128 / 2 + (this.maxHeight - maxHeight), 256, 128 + maxHeight - this.minHeight - 1);
            }
            case 1: {
                return new Rectangle(xOffset + (this.maxY - y - x) * 128, yOffset + (this.maxY - y + x) * 128 / 2 + (this.maxHeight - maxHeight), 256, 128 + maxHeight - this.minHeight - 1);
            }
            case 2: {
                return new Rectangle(xOffset + (this.maxX - x - (this.maxY - y)) * 128, yOffset + (this.maxX - x + (this.maxY - y)) * 128 / 2 + (this.maxHeight - maxHeight), 256, 128 + maxHeight - this.minHeight - 1);
            }
            case 3: {
                return new Rectangle(xOffset + (y - (this.maxX - x)) * 128, yOffset + (y + (this.maxX - x)) * 128 / 2 + (this.maxHeight - maxHeight), 256, 128 + maxHeight - this.minHeight - 1);
            }
        }
        throw new IllegalArgumentException();
    }

    private void moveTo(Point coords) {
        Rectangle visibleRect = this.getVisibleRect();
        this.scrollRectToVisible(new Rectangle(coords.x - visibleRect.width / 2, coords.y - visibleRect.height / 2, visibleRect.width, visibleRect.height));
    }

    private java.awt.Dimension zoom(java.awt.Dimension dimension) {
        if (this.zoom < 1) {
            dimension.width /= this.scale;
            dimension.height /= this.scale;
        } else if (this.zoom > 1) {
            dimension.width *= this.scale;
            dimension.height *= this.scale;
        }
        return dimension;
    }

    private Point zoom(Point point) {
        if (this.zoom < 1) {
            point.x /= this.scale;
            point.y /= this.scale;
        } else if (this.zoom > 1) {
            point.x *= this.scale;
            point.y *= this.scale;
        }
        return point;
    }

    private Rectangle zoom(Rectangle rectangle) {
        if (this.zoom < 1) {
            rectangle.x /= this.scale;
            rectangle.y /= this.scale;
            rectangle.width /= this.scale;
            rectangle.height /= this.scale;
        } else if (this.zoom > 1) {
            rectangle.x *= this.scale;
            rectangle.y *= this.scale;
            rectangle.width *= this.scale;
            rectangle.height *= this.scale;
        }
        return rectangle;
    }

    private Rectangle unzoom(Rectangle rectangle) {
        if (this.zoom < 1) {
            rectangle.x *= this.scale;
            rectangle.y *= this.scale;
            rectangle.width *= this.scale;
            rectangle.height *= this.scale;
        } else if (this.zoom > 1) {
            rectangle.x /= this.scale;
            rectangle.y /= this.scale;
            rectangle.width /= this.scale;
            rectangle.height /= this.scale;
        }
        return rectangle;
    }

    private java.awt.Dimension unzoom(java.awt.Dimension dimension) {
        if (this.zoom < 1) {
            dimension.width *= this.scale;
            dimension.height *= this.scale;
        } else if (this.zoom > 1) {
            dimension.width /= this.scale;
            dimension.height /= this.scale;
        }
        return dimension;
    }

    public static enum RefreshMode {
        IMMEDIATE,
        DELAYED,
        MANUAL;

    }
}

