/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.threedeeview;

import java.util.HashSet;
import java.util.Set;
import org.pepsoft.util.jobqueue.Job;
import org.pepsoft.util.jobqueue.UniqueJobQueue;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.threedeeview.Background3DTileRenderer;
import org.pepsoft.worldpainter.threedeeview.RenderResult;
import org.pepsoft.worldpainter.threedeeview.Tile3DRenderJob;
import org.pepsoft.worldpainter.threedeeview.Tile3DRenderer;

public class ThreeDeeRenderManager {
    private final Dimension dimension;
    private final ColourScheme colourScheme;
    private final CustomBiomeManager customBiomeManager;
    private final int rotation;
    private HashSet<RenderResult> results = new HashSet();
    private Background3DTileRenderer[] renderThreads;
    private UniqueJobQueue<Tile3DRenderJob> jobQueue;
    private Tile3DRenderer.LayerVisibilityMode layerVisibility;
    private Set<Layer> hiddenLayers;

    public ThreeDeeRenderManager(Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int rotation) {
        this.dimension = dimension;
        this.colourScheme = colourScheme;
        this.customBiomeManager = customBiomeManager;
        this.rotation = rotation;
    }

    public synchronized void renderTile(Tile tile) {
        if (this.jobQueue == null) {
            this.startThreads();
        }
        this.jobQueue.scheduleJobIfNotScheduled((Job)new Tile3DRenderJob(tile));
    }

    public synchronized Set<RenderResult> getRenderedTiles() {
        HashSet<RenderResult> rc = this.results;
        this.results = new HashSet();
        return rc;
    }

    public synchronized void renderAllTiles() throws InterruptedException {
        if (this.jobQueue != null) {
            this.jobQueue.drain();
            for (Background3DTileRenderer renderThread : this.renderThreads) {
                renderThread.waitToIdle();
            }
        }
    }

    public synchronized void stop() {
        if (this.renderThreads != null) {
            for (Background3DTileRenderer renderThread : this.renderThreads) {
                renderThread.halt();
            }
        }
        this.renderThreads = null;
        this.jobQueue = null;
        this.results.clear();
    }

    synchronized void tileFinished(RenderResult renderResult) {
        this.results.add(renderResult);
    }

    public void setLayerVisibility(Tile3DRenderer.LayerVisibilityMode layerVisibility) {
        this.layerVisibility = layerVisibility;
    }

    public void setHiddenLayers(Set<Layer> hiddenLayers) {
        this.hiddenLayers = hiddenLayers;
    }

    private void startThreads() {
        this.jobQueue = new UniqueJobQueue();
        int noOfThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        this.renderThreads = new Background3DTileRenderer[noOfThreads];
        for (int i = 0; i < noOfThreads; ++i) {
            this.renderThreads[i] = new Background3DTileRenderer(this.dimension, this.colourScheme, this.customBiomeManager, this.rotation, this.jobQueue, this, this.layerVisibility, this.hiddenLayers);
            this.renderThreads[i].start();
        }
    }
}

