/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.threedeeview;

import java.awt.image.BufferedImage;
import java.util.Set;
import org.pepsoft.util.jobqueue.UniqueJobQueue;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.threedeeview.RenderResult;
import org.pepsoft.worldpainter.threedeeview.ThreeDeeRenderManager;
import org.pepsoft.worldpainter.threedeeview.Tile3DRenderJob;
import org.pepsoft.worldpainter.threedeeview.Tile3DRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Background3DTileRenderer
extends Thread {
    private final UniqueJobQueue<Tile3DRenderJob> jobQueue;
    private final ThreeDeeRenderManager threeDeeRenderManager;
    private final Tile3DRenderer renderer;
    private volatile boolean running = true;
    private volatile boolean rendering;
    private static final Logger logger = LoggerFactory.getLogger(Background3DTileRenderer.class);

    public Background3DTileRenderer(Dimension dimension, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, int rotation, UniqueJobQueue<Tile3DRenderJob> jobQueue, ThreeDeeRenderManager threeDeeRenderManager, Tile3DRenderer.LayerVisibilityMode layerVisibility, Set<Layer> hiddenLayers) {
        super("Background 3D renderer");
        this.jobQueue = jobQueue;
        this.threeDeeRenderManager = threeDeeRenderManager;
        this.renderer = new Tile3DRenderer(dimension, colourScheme, customBiomeManager, rotation, layerVisibility, hiddenLayers);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block7: {
            if (logger.isDebugEnabled()) {
                logger.debug("Background 3D rendering thread started");
            }
            try {
                while (this.running) {
                    Background3DTileRenderer background3DTileRenderer = this;
                    synchronized (background3DTileRenderer) {
                        Tile3DRenderJob job = (Tile3DRenderJob)this.jobQueue.takeJob();
                        Tile tile = job.getTile();
                        this.renderTile(tile);
                    }
                }
            }
            catch (InterruptedException e) {
                if (!this.running) break block7;
                throw new RuntimeException("Thread interrupted while waiting for render job", e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Background 3D rendering thread halted");
        }
    }

    public void halt() {
        this.running = false;
        this.interrupt();
    }

    public synchronized void waitToIdle() {
    }

    private void renderTile(Tile tile) {
        if (logger.isTraceEnabled()) {
            logger.trace("Rendering 3D view of tile " + tile);
        }
        BufferedImage image = this.renderer.render(tile);
        if (this.running) {
            this.threeDeeRenderManager.tileFinished(new RenderResult(tile, image));
        }
    }
}

