/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.worldpainter.Terrain;

public class TerrainRangesTableModel
implements TableModel {
    private final JButton deleteButton = new JButton("Delete");
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private int[] levels;
    private Terrain[] terrains;
    private int rows;
    private ChangeListener changeListener;

    public TerrainRangesTableModel(SortedMap<Integer, Terrain> terrainRanges) {
        this.levels = new int[terrainRanges.size()];
        this.terrains = new Terrain[terrainRanges.size()];
        this.rows = terrainRanges.size();
        int i = 0;
        for (Map.Entry<Integer, Terrain> row : terrainRanges.entrySet()) {
            this.levels[i] = row.getKey() + 1;
            this.terrains[i] = row.getValue();
            if (this.terrains[i] == null) {
                throw new IllegalArgumentException("terrainRanges contains null value: " + terrainRanges);
            }
            ++i;
        }
    }

    public void addRow(int level, Terrain terrain) {
        int i;
        if (terrain == null) {
            throw new NullPointerException("terrain");
        }
        TreeMap<Integer, Terrain> sortedMap = new TreeMap<Integer, Terrain>();
        sortedMap.put(level, terrain);
        for (i = 0; i < this.rows; ++i) {
            sortedMap.put(this.levels[i], this.terrains[i]);
        }
        ++this.rows;
        if (this.rows > this.levels.length) {
            this.levels = new int[this.rows];
            this.terrains = new Terrain[this.rows];
        }
        i = 0;
        for (Map.Entry row : sortedMap.entrySet()) {
            this.levels[i] = (Integer)row.getKey();
            this.terrains[i] = (Terrain)row.getValue();
            ++i;
        }
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
        this.notifyChangeListener();
    }

    public void deleteRow(int row) {
        System.arraycopy(this.levels, row + 1, this.levels, row, this.rows - 1 - row);
        System.arraycopy(this.terrains, row + 1, this.terrains, row, this.rows - 1 - row);
        --this.rows;
        TableModelEvent event = new TableModelEvent(this, row, row, -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
        this.notifyChangeListener();
    }

    public SortedMap<Integer, Terrain> getTerrainRanges() {
        TreeMap<Integer, Terrain> terrainRanges = new TreeMap<Integer, Terrain>();
        for (int i = 0; i < this.rows; ++i) {
            terrainRanges.put(this.levels[i] - 1, this.terrains[i]);
        }
        return terrainRanges;
    }

    public boolean isValid() {
        for (int i = 1; i < this.rows; ++i) {
            if (this.levels[i] != this.levels[i - 1]) continue;
            return false;
        }
        return true;
    }

    public ChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Level";
            }
            case 1: {
                return "Terrain type";
            }
            case 2: {
                return "Actions";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Terrain.class;
            }
            case 2: {
                return JButton.class;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex > 0 || columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.levels[rowIndex];
            }
            case 1: {
                return this.terrains[rowIndex];
            }
            case 2: {
                if (rowIndex > 0) {
                    return this.deleteButton;
                }
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            throw new NullPointerException("aValue (rowIndex: " + rowIndex + ", columnIndex: " + columnIndex + ")");
        }
        switch (columnIndex) {
            case 0: {
                this.levels[rowIndex] = (Integer)aValue;
                this.sortIfNeeded();
                this.notifyChangeListener();
                break;
            }
            case 1: {
                this.terrains[rowIndex] = (Terrain)aValue;
                this.notifyChangeListener();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    private void sortIfNeeded() {
        for (int i = 1; i < this.rows; ++i) {
            int j;
            if (this.levels[i] >= this.levels[i - 1]) continue;
            TreeMap<Integer, Terrain> sortedMap = new TreeMap<Integer, Terrain>();
            for (j = 0; j < this.rows; ++j) {
                sortedMap.put(this.levels[j], this.terrains[j]);
            }
            j = 0;
            for (Map.Entry row : sortedMap.entrySet()) {
                this.levels[j] = (Integer)row.getKey();
                this.terrains[j] = (Terrain)row.getValue();
                ++j;
            }
            TableModelEvent event = new TableModelEvent(this, 0, this.rows - 1);
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(event);
            }
            this.notifyChangeListener();
            break;
        }
    }

    private void notifyChangeListener() {
        if (this.changeListener != null) {
            this.changeListener.dataChanged(this);
        }
    }

    public static interface ChangeListener {
        public void dataChanged(TerrainRangesTableModel var1);
    }
}

