/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.simple;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.pepsoft.worldpainter.LayerListCellRenderer;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.themes.Filter;
import org.pepsoft.worldpainter.themes.HeightFilter;

public class AddLayerDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonOK;
    private JCheckBox checkBoxFeather;
    private JComboBox comboBoxLayer;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSpinner spinnerFrom;
    private JSpinner spinnerTo;
    private final int minHeight;
    private final int maxHeight;

    public AddLayerDialog(Window parent, List<Layer> layers, int minHeight, int maxHeight) {
        super(parent);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.initComponents();
        DefaultComboBoxModel<Layer> comboBoxModel = new DefaultComboBoxModel<Layer>(layers.toArray(new Layer[layers.size()]));
        this.comboBoxLayer.setModel(comboBoxModel);
        this.comboBoxLayer.setRenderer(new LayerListCellRenderer());
        ((SpinnerNumberModel)this.spinnerFrom.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerFrom.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        this.spinnerFrom.setValue((minHeight + maxHeight) / 2);
        ((SpinnerNumberModel)this.spinnerTo.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerTo.getModel()).setMaximum(Integer.valueOf(maxHeight - 1));
        this.spinnerTo.setValue(minHeight + maxHeight - 1);
        this.setControlStates();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public Layer getSelectedLayer() {
        return (Layer)this.comboBoxLayer.getSelectedItem();
    }

    public Filter getSelectedFilter() {
        return new HeightFilter(this.minHeight, this.maxHeight, ((Integer)this.spinnerFrom.getValue()).intValue(), ((Integer)this.spinnerTo.getValue()).intValue(), this.checkBoxFeather.isSelected());
    }

    private void setControlStates() {
        this.buttonOK.setEnabled(this.comboBoxLayer.getSelectedItem() != null);
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.comboBoxLayer = new JComboBox();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.spinnerFrom = new JSpinner();
        this.jLabel3 = new JLabel();
        this.spinnerTo = new JSpinner();
        this.jLabel4 = new JLabel();
        this.checkBoxFeather = new JCheckBox();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(2);
        this.setTitle("Add Layer Mapping");
        this.jLabel1.setText("Configure a layer to add to the mapping:");
        this.comboBoxLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboBoxLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLayerDialog.this.comboBoxLayerActionPerformed(evt);
            }
        });
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLayerDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.setEnabled(false);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddLayerDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.spinnerFrom);
        this.jLabel2.setText("From:");
        this.spinnerFrom.setModel(new SpinnerNumberModel(128, 0, 255, 1));
        this.jLabel3.setLabelFor(this.spinnerTo);
        this.jLabel3.setText("To:");
        this.spinnerTo.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        this.jLabel4.setLabelFor(this.comboBoxLayer);
        this.jLabel4.setText("Layer:");
        this.checkBoxFeather.setText("Feather:");
        this.checkBoxFeather.setHorizontalTextPosition(10);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerFrom, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerTo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxFeather).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxLayer, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.buttonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxLayer, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.spinnerFrom, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.spinnerTo, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.checkBoxFeather)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void comboBoxLayerActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }
}

