/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Terrain;

class TerrainCellRendererHelper {
    private final ColourScheme colourScheme;
    private final Map<BufferedImage, ImageIcon> iconCache = new HashMap<BufferedImage, ImageIcon>();

    TerrainCellRendererHelper(ColourScheme colourScheme) {
        this.colourScheme = colourScheme;
    }

    void configure(JLabel label, Terrain terrain) {
        if (terrain != null) {
            BufferedImage image = terrain.getScaledIcon(16, this.colourScheme);
            ImageIcon icon = this.iconCache.get(image);
            if (icon == null) {
                icon = new ImageIcon(image);
                this.iconCache.put(image, icon);
            }
            label.setIcon(icon);
            label.setText(terrain.getName());
        }
    }
}

