/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.superflat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.minecraft.SuperflatPreset;

public class SuperflatPresetStructuresTableModel
implements TableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_ENABLED = 1;
    public static final int COLUMN_PARAMS = 2;
    public static final String[] COLUMN_NAMES = new String[]{"Structure", "Enabled", "Parameters"};
    public static final Class<?>[] COLUMN_TYPES = new Class[]{String.class, Boolean.class, String.class};
    private final SuperflatPreset.Structure[] allStructures;
    private final Map<String, String>[] params;
    private final boolean[] enabled;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public SuperflatPresetStructuresTableModel(Map<SuperflatPreset.Structure, Map<String, String>> structures) {
        this.allStructures = SuperflatPreset.Structure.values();
        Arrays.sort(this.allStructures);
        this.params = new Map[this.allStructures.length];
        this.enabled = new boolean[this.allStructures.length];
        for (int i = 0; i < this.allStructures.length; ++i) {
            if (structures.containsKey(this.allStructures[i])) {
                this.params[i] = new HashMap<String, String>(structures.get(this.allStructures[i]));
                this.enabled[i] = true;
                continue;
            }
            this.params[i] = new HashMap<String, String>();
            this.enabled[i] = false;
        }
    }

    public Map<SuperflatPreset.Structure, Map<String, String>> getStructures() {
        HashMap<SuperflatPreset.Structure, Map<String, String>> structures = new HashMap<SuperflatPreset.Structure, Map<String, String>>();
        for (int i = 0; i < this.allStructures.length; ++i) {
            if (!this.enabled[i]) continue;
            structures.put(this.allStructures[i], this.params[i]);
        }
        return structures;
    }

    @Override
    public int getRowCount() {
        return this.params.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.allStructures[rowIndex].name().toLowerCase();
            }
            case 1: {
                return this.enabled[rowIndex];
            }
            case 2: {
                return this.params[rowIndex].isEmpty() ? "" : this.params[rowIndex].entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" "));
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                throw new IllegalArgumentException("columnIndex " + columnIndex);
            }
            case 1: {
                this.enabled[rowIndex] = (Boolean)aValue;
                break;
            }
            case 2: {
                this.params[rowIndex] = new HashMap<String, String>();
                String text = (String)aValue;
                if (text.trim().isEmpty()) break;
                for (String param : text.trim().split(" ")) {
                    int p = param.indexOf(61);
                    this.params[rowIndex].put(param.substring(0, p), param.substring(p + 1));
                }
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

