/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.superflat;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.minecraft.SuperflatPreset;

public class SuperflatPresetLayersTableModel
implements TableModel {
    private final List<SuperflatPreset.Layer> layers;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private static final String[] COLUMN_NAMES = new String[]{"Material", "Thickness"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{String.class, Integer.class};
    private static final int COLUMN_MATERIAL = 0;
    private static final int COLUMN_THICKNESS = 1;

    public SuperflatPresetLayersTableModel(List<SuperflatPreset.Layer> layers) {
        this.layers = layers.stream().map(layer -> new SuperflatPreset.Layer(layer.getMaterialName(), layer.getThickness())).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addLayer(SuperflatPreset.Layer layer) {
        this.layers.add(layer);
        TableModelEvent event = new TableModelEvent(this, this.layers.size() - 1, this.layers.size() - 1, -1, 1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public void deleteLayer(int rowIndex) {
        this.layers.remove(rowIndex);
        TableModelEvent event = new TableModelEvent(this, this.layers.size() - 1, this.layers.size() - 1, -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public List<SuperflatPreset.Layer> getLayers() {
        return this.layers;
    }

    @Override
    public int getRowCount() {
        return this.layers.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.layers.get(rowIndex).getMaterialName();
            }
            case 1: {
                return this.layers.get(rowIndex).getThickness();
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.layers.get(rowIndex).setMaterialName((String)aValue);
                break;
            }
            case 1: {
                this.layers.get(rowIndex).setThickness(((Integer)aValue).intValue());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

