/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.superflat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.AbstractMinecraft1_1BiomeScheme;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_17Biomes;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_21Biomes;
import org.pepsoft.worldpainter.biomeschemes.Minecraft1_7Biomes;
import org.pepsoft.worldpainter.superflat.SuperflatPresetLayersTableModel;
import org.pepsoft.worldpainter.superflat.SuperflatPresetStructuresTableModel;

public class EditSuperflatPresetDialog
extends WorldPainterDialog {
    private JButton buttonCancel;
    private JButton buttonLayerAdd;
    private JButton buttonLayerDelete;
    private JButton buttonOK;
    private JCheckBox checkBoxFeatures;
    private JCheckBox checkBoxLakes;
    private JComboBox comboBoxBiome;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel labelStructures;
    private JTable tableLayers;
    private JTable tableStructures;
    private final SuperflatPreset superflatPreset;
    private final Platform platform;
    private final SuperflatPresetLayersTableModel layersTableModel;
    private final SuperflatPresetStructuresTableModel structuresTableModel;

    public EditSuperflatPresetDialog(Window parent, Platform platform, SuperflatPreset superflatPreset) {
        super(parent);
        this.platform = platform;
        this.superflatPreset = superflatPreset;
        this.initComponents();
        this.tableLayers.getSelectionModel().addListSelectionListener(e -> this.setControlStates());
        if (platform.capabilities.contains(Platform.Capability.NAMED_BIOMES)) {
            String[] availableBiomes = (String[])Arrays.stream(Minecraft1_21Biomes.MODERN_IDS).filter(Objects::nonNull).distinct().sorted().toArray(String[]::new);
            this.comboBoxBiome.setModel(new DefaultComboBoxModel<String>(availableBiomes));
            this.comboBoxBiome.setEditable(true);
            if (superflatPreset.getBiomeName() != null) {
                this.comboBoxBiome.setSelectedItem(superflatPreset.getBiomeName());
            } else if (Minecraft1_21Biomes.MODERN_IDS[superflatPreset.getBiome()] != null) {
                this.comboBoxBiome.setSelectedItem(Minecraft1_21Biomes.MODERN_IDS[superflatPreset.getBiome()]);
            } else {
                this.comboBoxBiome.setSelectedItem("minecraft:plains");
            }
        } else if (platform == DefaultPlugin.JAVA_ANVIL_1_15 || platform == DefaultPlugin.JAVA_ANVIL_1_17) {
            String[] availableBiomes = (String[])Arrays.stream(Minecraft1_17Biomes.BIOME_NAMES).filter(Objects::nonNull).map(biome -> "minecraft:" + biome.toLowerCase().replace(' ', '_')).toArray(String[]::new);
            this.comboBoxBiome.setModel(new DefaultComboBoxModel<String>(availableBiomes));
            this.comboBoxBiome.setEditable(true);
            if (superflatPreset.getBiomeName() != null) {
                this.comboBoxBiome.setSelectedItem(superflatPreset.getBiomeName());
            } else if (Minecraft1_17Biomes.BIOME_NAMES[superflatPreset.getBiome()] != null) {
                this.comboBoxBiome.setSelectedItem("minecraft:" + Minecraft1_17Biomes.BIOME_NAMES[superflatPreset.getBiome()].toLowerCase().replace(' ', '_'));
            } else {
                this.comboBoxBiome.setSelectedItem("minecraft:plains");
            }
        } else {
            final String[] biomeNames = platform == DefaultPlugin.JAVA_MCREGION ? AbstractMinecraft1_1BiomeScheme.BIOME_NAMES : (platform == DefaultPlugin.JAVA_ANVIL ? Minecraft1_7Biomes.BIOME_NAMES : Minecraft1_17Biomes.BIOME_NAMES);
            Integer[] availableBiomes = (Integer[])IntStream.range(0, biomeNames.length).filter(i -> biomeNames[i] != null).boxed().toArray(Integer[]::new);
            this.comboBoxBiome.setModel(new DefaultComboBoxModel<Integer>(availableBiomes));
            this.comboBoxBiome.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setText(biomeNames[(Integer)value] + " (" + value + ")");
                    return this;
                }
            });
            this.comboBoxBiome.setSelectedItem(superflatPreset.getBiome());
        }
        this.layersTableModel = new SuperflatPresetLayersTableModel(superflatPreset.getLayers());
        this.tableLayers.setModel(this.layersTableModel);
        if (platform == DefaultPlugin.JAVA_MCREGION || platform == DefaultPlugin.JAVA_ANVIL || platform == DefaultPlugin.JAVA_ANVIL_1_15) {
            this.structuresTableModel = new SuperflatPresetStructuresTableModel(superflatPreset.getStructures());
            this.tableStructures.setModel(this.structuresTableModel);
            this.checkBoxFeatures.setVisible(false);
            this.checkBoxLakes.setVisible(false);
        } else {
            this.structuresTableModel = null;
            this.labelStructures.setVisible(false);
            this.tableStructures.setVisible(false);
            this.checkBoxFeatures.setSelected(superflatPreset.isFeatures());
            this.checkBoxLakes.setSelected(superflatPreset.isLakes());
        }
        this.setControlStates();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.scaleToUI();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void setControlStates() {
        this.buttonLayerDelete.setEnabled(this.tableLayers.getSelectedRowCount() > 0);
    }

    private boolean save() {
        Object selectedBiome = this.comboBoxBiome.getSelectedItem();
        if (selectedBiome instanceof String) {
            this.superflatPreset.setBiomeName((String)selectedBiome);
            this.superflatPreset.setBiome(Minecraft1_21Biomes.BIOMES_BY_MODERN_ID.getOrDefault(selectedBiome, 1).intValue());
        } else if (selectedBiome instanceof Integer) {
            this.superflatPreset.setBiome(((Integer)selectedBiome).intValue());
            if (Minecraft1_21Biomes.MODERN_IDS[(Integer)selectedBiome] != null) {
                this.superflatPreset.setBiomeName(Minecraft1_21Biomes.MODERN_IDS[(Integer)selectedBiome]);
            } else {
                this.superflatPreset.setBiomeName("minecraft:plains");
            }
        }
        this.superflatPreset.setLayers(this.layersTableModel.getLayers());
        if (this.platform == DefaultPlugin.JAVA_MCREGION || this.platform == DefaultPlugin.JAVA_ANVIL || this.platform == DefaultPlugin.JAVA_ANVIL_1_15) {
            this.superflatPreset.setStructures(this.structuresTableModel.getStructures());
        } else {
            this.superflatPreset.setFeatures(this.checkBoxFeatures.isSelected());
            this.superflatPreset.setLakes(this.checkBoxLakes.isSelected());
        }
        return true;
    }

    private void addLayer() {
        this.layersTableModel.addLayer(new SuperflatPreset.Layer("minecraft:dirt", 1));
    }

    private void deleteLayer() {
        this.layersTableModel.deleteLayer(this.tableLayers.getSelectedRow());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableLayers = new JTable();
        this.buttonLayerAdd = new JButton();
        this.buttonLayerDelete = new JButton();
        this.jLabel2 = new JLabel();
        this.comboBoxBiome = new JComboBox();
        this.buttonCancel = new JButton();
        this.buttonOK = new JButton();
        this.tableStructures = new JTable();
        this.labelStructures = new JLabel();
        this.checkBoxFeatures = new JCheckBox();
        this.checkBoxLakes = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Superflat Preset");
        this.jLabel1.setText("Biome:");
        this.tableLayers.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.tableLayers);
        this.buttonLayerAdd.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_add.png")));
        this.buttonLayerAdd.setToolTipText("Add a layer.");
        this.buttonLayerAdd.setMargin(new Insets(2, 2, 2, 2));
        this.buttonLayerAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditSuperflatPresetDialog.this.buttonLayerAddActionPerformed(evt);
            }
        });
        this.buttonLayerDelete.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/brick_delete.png")));
        this.buttonLayerDelete.setToolTipText("Delete the selected layer.");
        this.buttonLayerDelete.setEnabled(false);
        this.buttonLayerDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonLayerDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditSuperflatPresetDialog.this.buttonLayerDeleteActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Layers:");
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditSuperflatPresetDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditSuperflatPresetDialog.this.buttonOKActionPerformed(evt);
            }
        });
        this.tableStructures.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.tableStructures.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tableStructures.setSelectionMode(0);
        this.tableStructures.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditSuperflatPresetDialog.this.tableStructuresMouseClicked(evt);
            }
        });
        this.labelStructures.setText("Structures:");
        this.checkBoxFeatures.setText("features");
        this.checkBoxLakes.setText("lakes");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableStructures, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 614, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonLayerAdd, GroupLayout.Alignment.TRAILING).addComponent(this.buttonLayerDelete, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxFeatures).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxBiome, -2, -1, -2)).addComponent(this.labelStructures)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxLakes).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.buttonOK))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboBoxBiome, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonLayerAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonLayerDelete)).addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.labelStructures).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableStructures, -1, 87, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.checkBoxFeatures).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLakes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOK).addComponent(this.buttonCancel)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void buttonOKActionPerformed(ActionEvent evt) {
        if (this.tableLayers.isEditing()) {
            this.tableLayers.getCellEditor().stopCellEditing();
        }
        if (this.tableStructures.isEditing()) {
            this.tableStructures.getCellEditor().stopCellEditing();
        }
        if (this.save()) {
            this.ok();
        }
    }

    private void buttonLayerAddActionPerformed(ActionEvent evt) {
        this.addLayer();
    }

    private void buttonLayerDeleteActionPerformed(ActionEvent evt) {
        this.deleteLayer();
    }

    private void tableStructuresMouseClicked(MouseEvent evt) {
    }
}

