/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.selection;

import java.awt.image.BufferedImage;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.painting.AbstractPaint;
import org.pepsoft.worldpainter.selection.SelectionHelper;

public class SelectionPaint
extends AbstractPaint {
    private Dimension dimension;
    private SelectionHelper selectionHelper;
    private static final BufferedImage ICON = IconUtils.loadScaledImage((String)"org/pepsoft/worldpainter/icons/edit_selection.png");

    @Override
    public String getId() {
        return "Layer/org.pepsoft.worldpainter.selection";
    }

    @Override
    public void apply(Dimension dimension, int x, int y, float dynamicLevel) {
        if (dimension != this.dimension) {
            this.dimension = dimension;
            this.selectionHelper = new SelectionHelper(dimension);
        }
        try {
            this.selectionHelper.addToSelection(x, y, this.brush, this.filter, dynamicLevel, null);
        }
        catch (ProgressReceiver.OperationCancelled operationCancelled) {
            throw new InternalError();
        }
    }

    @Override
    public void remove(Dimension dimension, int x, int y, float dynamicLevel) {
        if (dimension != this.dimension) {
            this.dimension = dimension;
            this.selectionHelper = new SelectionHelper(dimension);
        }
        try {
            this.selectionHelper.removeFromSelection(x, y, this.brush, this.filter, dynamicLevel, null);
        }
        catch (ProgressReceiver.OperationCancelled operationCancelled) {
            throw new InternalError();
        }
    }

    @Override
    public void applyPixel(Dimension dimension, int x, int y) {
        if (dimension != this.dimension) {
            this.dimension = dimension;
            this.selectionHelper = new SelectionHelper(dimension);
        }
    }

    @Override
    public void removePixel(Dimension dimension, int x, int y) {
        if (dimension != this.dimension) {
            this.dimension = dimension;
            this.selectionHelper = new SelectionHelper(dimension);
        }
    }

    @Override
    public BufferedImage getIcon(ColourScheme colourScheme) {
        return ICON;
    }
}

